/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.InvocableHandlerMethod;
import org.springframework.web.reactive.result.method.SyncHandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.SyncInvocableHandlerMethod;
import org.springframework.web.reactive.result.method.annotation.InitBinderBindingContext;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

class BindingContextFactory {
    private final RequestMappingHandlerAdapter adapter;

    public BindingContextFactory(RequestMappingHandlerAdapter adapter) {
        this.adapter = adapter;
    }

    public RequestMappingHandlerAdapter getAdapter() {
        return this.adapter;
    }

    private WebBindingInitializer getBindingInitializer() {
        return this.getAdapter().getWebBindingInitializer();
    }

    private List<SyncHandlerMethodArgumentResolver> getInitBinderArgumentResolvers() {
        return this.getAdapter().getInitBinderArgumentResolvers();
    }

    private List<HandlerMethodArgumentResolver> getArgumentResolvers() {
        return this.getAdapter().getArgumentResolvers();
    }

    private ReactiveAdapterRegistry getAdapterRegistry() {
        return this.getAdapter().getReactiveAdapterRegistry();
    }

    private Stream<Method> getInitBinderMethods(HandlerMethod handlerMethod) {
        return this.getAdapter().getInitBinderMethods(handlerMethod.getBeanType()).stream();
    }

    private Stream<Method> getModelAttributeMethods(HandlerMethod handlerMethod) {
        return this.getAdapter().getModelAttributeMethods(handlerMethod.getBeanType()).stream();
    }

    public Mono<BindingContext> createBindingContext(HandlerMethod handlerMethod, ServerWebExchange exchange) {
        List<SyncInvocableHandlerMethod> invocableMethods = this.getInitBinderMethods(handlerMethod).map(method -> {
            Object bean = handlerMethod.getBean();
            SyncInvocableHandlerMethod invocable = new SyncInvocableHandlerMethod(bean, (Method)method);
            invocable.setSyncArgumentResolvers(this.getInitBinderArgumentResolvers());
            return invocable;
        }).collect(Collectors.toList());
        InitBinderBindingContext bindingContext = new InitBinderBindingContext(this.getBindingInitializer(), invocableMethods);
        return this.initModel(handlerMethod, bindingContext, exchange).then(Mono.just((Object)bindingContext));
    }

    private Mono<Void> initModel(HandlerMethod handlerMethod, BindingContext context, ServerWebExchange exchange) {
        List resultMonos = this.getModelAttributeMethods(handlerMethod).map(method -> {
            Object bean = handlerMethod.getBean();
            InvocableHandlerMethod invocable = new InvocableHandlerMethod(bean, (Method)method);
            invocable.setArgumentResolvers(this.getArgumentResolvers());
            return invocable;
        }).map(invocable -> invocable.invoke(exchange, context, new Object[0])).collect(Collectors.toList());
        return Mono.when(resultMonos, resultArr -> this.processModelMethodMonos((Object[])resultArr, context)).then(voidMonos -> Mono.when((Iterable)voidMonos));
    }

    private List<Mono<Void>> processModelMethodMonos(Object[] resultArr, BindingContext context) {
        return Arrays.stream(resultArr).map(result -> this.processModelMethodResult((HandlerResult)result, context)).collect(Collectors.toList());
    }

    private Mono<Void> processModelMethodResult(HandlerResult result, BindingContext context) {
        Class valueType;
        Object value = result.getReturnValue().orElse(null);
        if (value == null) {
            return Mono.empty();
        }
        ResolvableType type = result.getReturnType();
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(type.getRawClass(), value);
        Class clazz = valueType = adapter != null ? type.resolveGeneric(new int[]{0}) : type.resolve();
        if (Void.class.equals((Object)valueType) || Void.TYPE.equals(valueType)) {
            return adapter != null ? Mono.from((Publisher)adapter.toPublisher(value)) : Mono.empty();
        }
        String name = this.getAttributeName(valueType, result.getReturnTypeSource());
        context.getModel().asMap().putIfAbsent(name, value);
        return Mono.empty();
    }

    private String getAttributeName(Class<?> valueType, MethodParameter parameter) {
        Method method = parameter.getMethod();
        ModelAttribute annot = (ModelAttribute)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ModelAttribute.class);
        if (annot != null && StringUtils.hasText((String)annot.value())) {
            return annot.value();
        }
        return ClassUtils.getShortNameAsProperty(valueType);
    }
}

