/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ErrorsMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final ReactiveAdapterRegistry adapterRegistry;

    public ErrorsMethodArgumentResolver(ReactiveAdapterRegistry registry) {
        Assert.notNull((Object)registry, (String)"'ReactiveAdapterRegistry' is required.");
        this.adapterRegistry = registry;
    }

    public ReactiveAdapterRegistry getAdapterRegistry() {
        return this.adapterRegistry;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        Class clazz = parameter.getParameterType();
        return Errors.class.isAssignableFrom(clazz);
    }

    @Override
    public Mono<Object> resolveArgument(MethodParameter parameter, BindingContext context, ServerWebExchange exchange) {
        Mono errorsMono;
        String name = this.getModelAttributeName(parameter);
        Object errors = context.getModel().asMap().get(BindingResult.MODEL_KEY_PREFIX + name);
        if (Mono.class.isAssignableFrom(errors.getClass())) {
            errorsMono = (Mono)errors;
        } else if (Errors.class.isAssignableFrom(errors.getClass())) {
            errorsMono = Mono.just(errors);
        } else {
            throw new IllegalStateException("Unexpected Errors/BindingResult type: " + errors.getClass().getName());
        }
        return errorsMono.cast(Object.class);
    }

    private String getModelAttributeName(MethodParameter parameter) {
        Assert.isTrue((parameter.getParameterIndex() > 0 ? 1 : 0) != 0, (String)"Errors argument must be immediately after a model attribute argument.");
        int index = parameter.getParameterIndex() - 1;
        MethodParameter attributeParam = new MethodParameter(parameter.getMethod(), index);
        Class attributeType = attributeParam.getParameterType();
        ResolvableType type = ResolvableType.forMethodParameter((MethodParameter)attributeParam);
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(type.resolve());
        Assert.isNull((Object)adapter, (String)"Errors/BindingResult cannot be used with an async model attribute. Either declare the model attribute without the async wrapper type or handle WebExchangeBindException through the async type.");
        ModelAttribute annot = (ModelAttribute)parameter.getParameterAnnotation(ModelAttribute.class);
        if (annot != null && StringUtils.hasText((String)annot.value())) {
            return annot.value();
        }
        return ClassUtils.getShortNameAsProperty((Class)attributeType);
    }
}

