/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueSyncArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;

public class RequestHeaderMethodArgumentResolver
extends AbstractNamedValueSyncArgumentResolver {
    public RequestHeaderMethodArgumentResolver(ConfigurableBeanFactory beanFactory) {
        super(beanFactory);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(RequestHeader.class) && !Map.class.isAssignableFrom(parameter.nestedIfOptional().getNestedParameterType());
    }

    @Override
    protected AbstractNamedValueArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        RequestHeader annotation = (RequestHeader)parameter.getParameterAnnotation(RequestHeader.class);
        return new RequestHeaderNamedValueInfo(annotation);
    }

    @Override
    protected Optional<Object> resolveNamedValue(String name, MethodParameter parameter, ServerWebExchange exchange) {
        List headerValues = exchange.getRequest().getHeaders().get((Object)name);
        List result = null;
        if (headerValues != null) {
            result = headerValues.size() == 1 ? headerValues.get(0) : headerValues;
        }
        return Optional.ofNullable(result);
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter parameter) {
        String type = parameter.getNestedParameterType().getSimpleName();
        throw new ServerWebInputException("Missing request header '" + name + "' for method parameter of type " + type);
    }

    private static class RequestHeaderNamedValueInfo
    extends AbstractNamedValueArgumentResolver.NamedValueInfo {
        private RequestHeaderNamedValueInfo(RequestHeader annotation) {
            super(annotation.name(), annotation.required(), annotation.defaultValue());
        }
    }
}

