/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.codec.ByteArrayDecoder;
import org.springframework.core.codec.ByteBufferDecoder;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.StringDecoder;
import org.springframework.http.codec.DecoderHttpMessageReader;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.annotation.ExceptionHandlerMethodResolver;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.HandlerAdapter;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.InvocableHandlerMethod;
import org.springframework.web.reactive.result.method.SyncHandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.BindingContextFactory;
import org.springframework.web.reactive.result.method.annotation.CookieValueMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ErrorsMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ExpressionValueMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.HttpEntityArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ModelArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ModelAttributeMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.PathVariableMapMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.PathVariableMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.PrincipalArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestAttributeMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestBodyArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestHeaderMapMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestHeaderMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestParamMapMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestParamMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ServerWebExchangeArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.SessionAttributeMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.WebSessionArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RequestMappingHandlerAdapter
implements HandlerAdapter,
BeanFactoryAware,
InitializingBean {
    private static final Log logger = LogFactory.getLog(RequestMappingHandlerAdapter.class);
    private final List<HttpMessageReader<?>> messageReaders = new ArrayList(10);
    private WebBindingInitializer webBindingInitializer;
    private ReactiveAdapterRegistry reactiveAdapters = new ReactiveAdapterRegistry();
    private List<HandlerMethodArgumentResolver> customArgumentResolvers;
    private List<HandlerMethodArgumentResolver> argumentResolvers;
    private List<SyncHandlerMethodArgumentResolver> customInitBinderArgumentResolvers;
    private List<SyncHandlerMethodArgumentResolver> initBinderArgumentResolvers;
    private ConfigurableBeanFactory beanFactory;
    private final BindingContextFactory bindingContextFactory = new BindingContextFactory(this);
    private final Map<Class<?>, Set<Method>> initBinderCache = new ConcurrentHashMap(64);
    private final Map<Class<?>, Set<Method>> modelAttributeCache = new ConcurrentHashMap(64);
    private final Map<Class<?>, ExceptionHandlerMethodResolver> exceptionHandlerCache = new ConcurrentHashMap(64);
    public static final ReflectionUtils.MethodFilter INIT_BINDER_METHODS = method -> AnnotationUtils.findAnnotation((Method)method, InitBinder.class) != null;
    public static final ReflectionUtils.MethodFilter MODEL_ATTRIBUTE_METHODS = method -> AnnotationUtils.findAnnotation((Method)method, RequestMapping.class) == null && AnnotationUtils.findAnnotation((Method)method, ModelAttribute.class) != null;

    public RequestMappingHandlerAdapter() {
        this.messageReaders.add((HttpMessageReader<?>)new DecoderHttpMessageReader((Decoder)new ByteArrayDecoder()));
        this.messageReaders.add((HttpMessageReader<?>)new DecoderHttpMessageReader((Decoder)new ByteBufferDecoder()));
        this.messageReaders.add((HttpMessageReader<?>)new DecoderHttpMessageReader((Decoder)new StringDecoder()));
    }

    public void setMessageReaders(List<HttpMessageReader<?>> messageReaders) {
        this.messageReaders.clear();
        this.messageReaders.addAll(messageReaders);
    }

    public List<HttpMessageReader<?>> getMessageReaders() {
        return this.messageReaders;
    }

    public void setWebBindingInitializer(WebBindingInitializer webBindingInitializer) {
        this.webBindingInitializer = webBindingInitializer;
    }

    public WebBindingInitializer getWebBindingInitializer() {
        return this.webBindingInitializer;
    }

    public void setReactiveAdapterRegistry(ReactiveAdapterRegistry registry) {
        this.reactiveAdapters = registry;
    }

    public ReactiveAdapterRegistry getReactiveAdapterRegistry() {
        return this.reactiveAdapters;
    }

    public void setCustomArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        this.customArgumentResolvers = resolvers;
    }

    public List<HandlerMethodArgumentResolver> getCustomArgumentResolvers() {
        return this.customArgumentResolvers;
    }

    public void setArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        this.argumentResolvers = new ArrayList<HandlerMethodArgumentResolver>(resolvers);
    }

    public List<HandlerMethodArgumentResolver> getArgumentResolvers() {
        return this.argumentResolvers;
    }

    public void setCustomInitBinderArgumentResolvers(List<SyncHandlerMethodArgumentResolver> resolvers) {
        this.customInitBinderArgumentResolvers = resolvers;
    }

    public List<SyncHandlerMethodArgumentResolver> getCustomInitBinderArgumentResolvers() {
        return this.customInitBinderArgumentResolvers;
    }

    public void setInitBinderArgumentResolvers(List<SyncHandlerMethodArgumentResolver> resolvers) {
        this.initBinderArgumentResolvers = null;
        if (resolvers != null) {
            this.initBinderArgumentResolvers = new ArrayList<SyncHandlerMethodArgumentResolver>();
            this.initBinderArgumentResolvers.addAll(resolvers);
        }
    }

    public List<SyncHandlerMethodArgumentResolver> getInitBinderArgumentResolvers() {
        return this.initBinderArgumentResolvers;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.beanFactory = (ConfigurableBeanFactory)beanFactory;
        }
    }

    public ConfigurableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.argumentResolvers == null) {
            this.argumentResolvers = this.getDefaultArgumentResolvers();
        }
        if (this.initBinderArgumentResolvers == null) {
            this.initBinderArgumentResolvers = this.getDefaultInitBinderArgumentResolvers();
        }
    }

    protected List<HandlerMethodArgumentResolver> getDefaultArgumentResolvers() {
        ArrayList<HandlerMethodArgumentResolver> resolvers = new ArrayList<HandlerMethodArgumentResolver>();
        resolvers.add(new RequestParamMethodArgumentResolver(this.getBeanFactory()));
        resolvers.add(new RequestParamMapMethodArgumentResolver());
        resolvers.add(new PathVariableMethodArgumentResolver(this.getBeanFactory()));
        resolvers.add(new PathVariableMapMethodArgumentResolver());
        resolvers.add(new RequestBodyArgumentResolver(this.getMessageReaders(), this.getReactiveAdapterRegistry()));
        resolvers.add(new ModelAttributeMethodArgumentResolver(this.getReactiveAdapterRegistry()));
        resolvers.add(new RequestHeaderMethodArgumentResolver(this.getBeanFactory()));
        resolvers.add(new RequestHeaderMapMethodArgumentResolver());
        resolvers.add(new CookieValueMethodArgumentResolver(this.getBeanFactory()));
        resolvers.add(new ExpressionValueMethodArgumentResolver(this.getBeanFactory()));
        resolvers.add(new SessionAttributeMethodArgumentResolver(this.getBeanFactory()));
        resolvers.add(new RequestAttributeMethodArgumentResolver(this.getBeanFactory()));
        resolvers.add(new HttpEntityArgumentResolver(this.getMessageReaders(), this.getReactiveAdapterRegistry()));
        resolvers.add(new ModelArgumentResolver());
        resolvers.add(new ErrorsMethodArgumentResolver(this.getReactiveAdapterRegistry()));
        resolvers.add(new ServerWebExchangeArgumentResolver());
        resolvers.add(new PrincipalArgumentResolver());
        resolvers.add(new WebSessionArgumentResolver());
        if (this.getCustomArgumentResolvers() != null) {
            resolvers.addAll(this.getCustomArgumentResolvers());
        }
        resolvers.add(new RequestParamMethodArgumentResolver(this.getBeanFactory(), true));
        resolvers.add(new ModelAttributeMethodArgumentResolver(this.getReactiveAdapterRegistry(), true));
        return resolvers;
    }

    protected List<SyncHandlerMethodArgumentResolver> getDefaultInitBinderArgumentResolvers() {
        ArrayList<SyncHandlerMethodArgumentResolver> resolvers = new ArrayList<SyncHandlerMethodArgumentResolver>();
        resolvers.add(new RequestParamMethodArgumentResolver(this.getBeanFactory(), false));
        resolvers.add(new RequestParamMapMethodArgumentResolver());
        resolvers.add(new PathVariableMethodArgumentResolver(this.getBeanFactory()));
        resolvers.add(new PathVariableMapMethodArgumentResolver());
        resolvers.add(new RequestHeaderMethodArgumentResolver(this.getBeanFactory()));
        resolvers.add(new RequestHeaderMapMethodArgumentResolver());
        resolvers.add(new CookieValueMethodArgumentResolver(this.getBeanFactory()));
        resolvers.add(new ExpressionValueMethodArgumentResolver(this.getBeanFactory()));
        resolvers.add(new RequestAttributeMethodArgumentResolver(this.getBeanFactory()));
        resolvers.add(new ModelArgumentResolver());
        resolvers.add(new ServerWebExchangeArgumentResolver());
        if (this.getCustomInitBinderArgumentResolvers() != null) {
            resolvers.addAll(this.getCustomInitBinderArgumentResolvers());
        }
        resolvers.add(new RequestParamMethodArgumentResolver(this.getBeanFactory(), true));
        return resolvers;
    }

    @Override
    public boolean supports(Object handler) {
        return HandlerMethod.class.equals(handler.getClass());
    }

    @Override
    public Mono<HandlerResult> handle(ServerWebExchange exchange, Object handler) {
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        InvocableHandlerMethod invocable = new InvocableHandlerMethod(handlerMethod);
        invocable.setArgumentResolvers(this.getArgumentResolvers());
        Mono<BindingContext> bindingContextMono = this.bindingContextFactory.createBindingContext(handlerMethod, exchange);
        return bindingContextMono.then(bindingContext -> invocable.invoke(exchange, (BindingContext)bindingContext, new Object[0]).doOnNext(result -> result.setExceptionHandler(ex -> this.handleException((Throwable)ex, handlerMethod, (BindingContext)bindingContext, exchange))).otherwise(ex -> this.handleException((Throwable)ex, handlerMethod, (BindingContext)bindingContext, exchange)));
    }

    Set<Method> getInitBinderMethods(Class<?> handlerType) {
        return this.initBinderCache.computeIfAbsent(handlerType, aClass -> MethodIntrospector.selectMethods((Class)handlerType, (ReflectionUtils.MethodFilter)INIT_BINDER_METHODS));
    }

    Set<Method> getModelAttributeMethods(Class<?> handlerType) {
        return this.modelAttributeCache.computeIfAbsent(handlerType, aClass -> MethodIntrospector.selectMethods((Class)handlerType, (ReflectionUtils.MethodFilter)MODEL_ATTRIBUTE_METHODS));
    }

    private Mono<HandlerResult> handleException(Throwable ex, HandlerMethod handlerMethod, BindingContext bindingContext, ServerWebExchange exchange) {
        block4: {
            InvocableHandlerMethod invocable = this.findExceptionHandler(handlerMethod, ex);
            if (invocable != null) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Invoking @ExceptionHandler method: " + invocable.getMethod()));
                    }
                    invocable.setArgumentResolvers(this.getArgumentResolvers());
                    bindingContext.getModel().asMap().clear();
                    return invocable.invoke(exchange, bindingContext, ex);
                }
                catch (Throwable invocationEx) {
                    if (!logger.isWarnEnabled()) break block4;
                    logger.warn((Object)("Failed to invoke @ExceptionHandler method: " + invocable.getMethod()), invocationEx);
                }
            }
        }
        return Mono.error((Throwable)ex);
    }

    protected InvocableHandlerMethod findExceptionHandler(HandlerMethod handlerMethod, Throwable exception) {
        Method method;
        if (handlerMethod == null) {
            return null;
        }
        Class handlerType = handlerMethod.getBeanType();
        ExceptionHandlerMethodResolver resolver = this.exceptionHandlerCache.get(handlerType);
        if (resolver == null) {
            resolver = new ExceptionHandlerMethodResolver(handlerType);
            this.exceptionHandlerCache.put(handlerType, resolver);
        }
        return (method = resolver.resolveMethodByExceptionType(exception.getClass())) != null ? new InvocableHandlerMethod(handlerMethod.getBean(), method) : null;
    }
}

