/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Map;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.SyncHandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;

public class RequestParamMapMethodArgumentResolver
implements SyncHandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        RequestParam requestParam = (RequestParam)parameter.getParameterAnnotation(RequestParam.class);
        if (requestParam != null && Map.class.isAssignableFrom(parameter.getParameterType())) {
            return !StringUtils.hasText((String)requestParam.name());
        }
        return false;
    }

    @Override
    public Optional<Object> resolveArgumentValue(MethodParameter parameter, BindingContext context, ServerWebExchange exchange) {
        MultiValueMap<String, String> requestParams = this.getRequestParams(exchange);
        Object value = this.isMultiValueMap(parameter) ? requestParams : requestParams.toSingleValueMap();
        return Optional.of(value);
    }

    private MultiValueMap<String, String> getRequestParams(ServerWebExchange exchange) {
        MultiValueMap params = (MultiValueMap)exchange.getRequestParams().subscribe().peek();
        Assert.notNull((Object)params, (String)"Expected form data (if any) to be parsed.");
        return params;
    }

    private boolean isMultiValueMap(MethodParameter parameter) {
        Class paramType = parameter.getParameterType();
        return MultiValueMap.class.isAssignableFrom(paramType);
    }
}

