/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.HandlerResultHandler;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.result.method.annotation.AbstractMessageWriterResultHandler;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ResponseBodyResultHandler
extends AbstractMessageWriterResultHandler
implements HandlerResultHandler {
    public ResponseBodyResultHandler(List<HttpMessageWriter<?>> messageWriters, RequestedContentTypeResolver contentTypeResolver) {
        this(messageWriters, contentTypeResolver, new ReactiveAdapterRegistry());
    }

    public ResponseBodyResultHandler(List<HttpMessageWriter<?>> messageWriters, RequestedContentTypeResolver contentTypeResolver, ReactiveAdapterRegistry adapterRegistry) {
        super(messageWriters, contentTypeResolver, adapterRegistry);
        this.setOrder(100);
    }

    @Override
    public boolean supports(HandlerResult result) {
        MethodParameter parameter = result.getReturnTypeSource();
        return this.hasResponseBodyAnnotation(parameter) && !this.isHttpEntityType(result);
    }

    private boolean hasResponseBodyAnnotation(MethodParameter parameter) {
        Class containingClass = parameter.getContainingClass();
        return AnnotationUtils.findAnnotation((Class)containingClass, ResponseBody.class) != null || parameter.getMethodAnnotation(ResponseBody.class) != null;
    }

    private boolean isHttpEntityType(HandlerResult result) {
        ResolvableType genericType;
        Class rawClass = result.getReturnType().getRawClass();
        if (HttpEntity.class.isAssignableFrom(rawClass)) {
            return true;
        }
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(rawClass, result.getReturnValue());
        return adapter != null && !adapter.isNoValue() && HttpEntity.class.isAssignableFrom((genericType = result.getReturnType().getGeneric(new int[]{0})).getRawClass());
    }

    @Override
    public Mono<Void> handleResult(ServerWebExchange exchange, HandlerResult result) {
        Object body = result.getReturnValue().orElse(null);
        MethodParameter bodyTypeParameter = result.getReturnTypeSource();
        return this.writeBody(body, bodyTypeParameter, exchange);
    }
}

