/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Encoder;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.reactive.result.view.View;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class HttpMessageWriterView
implements View {
    private final HttpMessageWriter<?> messageWriter;
    private final Set<String> modelKeys = new HashSet<String>(4);
    private final List<MediaType> mediaTypes;

    public HttpMessageWriterView(Encoder<?> encoder) {
        this((HttpMessageWriter<?>)new EncoderHttpMessageWriter(encoder));
    }

    public HttpMessageWriterView(HttpMessageWriter<?> messageWriter) {
        Assert.notNull(messageWriter, (String)"'messageWriter' is required.");
        this.messageWriter = messageWriter;
        this.mediaTypes = messageWriter.getWritableMediaTypes();
    }

    public HttpMessageWriter<?> getMessageWriter() {
        return this.messageWriter;
    }

    public void setModelKeys(Set<String> modelKeys) {
        this.modelKeys.clear();
        if (modelKeys != null) {
            this.modelKeys.addAll(modelKeys);
        }
    }

    public final Set<String> getModelKeys() {
        return this.modelKeys;
    }

    @Override
    public List<MediaType> getSupportedMediaTypes() {
        return this.mediaTypes;
    }

    @Override
    public Mono<Void> render(Map<String, ?> model, MediaType contentType, ServerWebExchange exchange) {
        Object value = this.extractObjectToRender(model);
        return this.applyMessageWriter(value, contentType, exchange);
    }

    protected Object extractObjectToRender(Map<String, ?> model) {
        HashMap map = new HashMap(model.size());
        for (Map.Entry<String, ?> entry : model.entrySet()) {
            if (!this.isEligibleAttribute(entry.getKey(), entry.getValue())) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        if (map.isEmpty()) {
            return null;
        }
        if (map.size() == 1) {
            return map.values().iterator().next();
        }
        if (this.getMessageWriter().canWrite(ResolvableType.forClass(Map.class), null)) {
            return map;
        }
        throw new IllegalStateException("Multiple matching attributes found: " + map + ". However Map rendering is not supported by " + this.getMessageWriter());
    }

    protected boolean isEligibleAttribute(String attributeName, Object attributeValue) {
        ResolvableType type = ResolvableType.forClass(attributeValue.getClass());
        if (this.getModelKeys().isEmpty()) {
            return this.getMessageWriter().canWrite(type, null);
        }
        if (this.getModelKeys().contains(attributeName)) {
            if (this.getMessageWriter().canWrite(type, null)) {
                return true;
            }
            throw new IllegalStateException("Model object [" + attributeValue + "] retrieved via key [" + attributeName + "] is not supported by " + this.getMessageWriter());
        }
        return false;
    }

    private <T> Mono<Void> applyMessageWriter(Object value, MediaType contentType, ServerWebExchange exchange) {
        if (value == null) {
            return Mono.empty();
        }
        Mono stream = Mono.just((Object)value);
        ResolvableType type = ResolvableType.forClass(value.getClass());
        ServerHttpResponse response = exchange.getResponse();
        return this.getMessageWriter().write((Publisher)stream, type, contentType, (ReactiveHttpOutputMessage)response, Collections.emptyMap());
    }
}

