/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.util.Assert;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.EscapedErrors;
import org.springframework.web.reactive.result.view.BindStatus;
import org.springframework.web.reactive.result.view.RequestDataValueProcessor;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.UriTemplate;

public class RequestContext {
    private final ServerWebExchange exchange;
    private final Map<String, Object> model;
    private final MessageSource messageSource;
    private Locale locale;
    private TimeZone timeZone;
    private Boolean defaultHtmlEscape;
    private Map<String, Errors> errorsMap;
    private RequestDataValueProcessor dataValueProcessor;

    public RequestContext(ServerWebExchange exchange, Map<String, Object> model, MessageSource messageSource) {
        this(exchange, model, messageSource, null);
    }

    public RequestContext(ServerWebExchange exchange, Map<String, Object> model, MessageSource messageSource, RequestDataValueProcessor dataValueProcessor) {
        Assert.notNull((Object)exchange, (String)"'exchange' is required");
        Assert.notNull(model, (String)"'model' is required");
        Assert.notNull((Object)messageSource, (String)"'messageSource' is required");
        this.exchange = exchange;
        this.model = model;
        this.messageSource = messageSource;
        Locale acceptLocale = exchange.getRequest().getHeaders().getAcceptLanguageAsLocale();
        this.locale = acceptLocale != null ? acceptLocale : Locale.getDefault();
        this.timeZone = TimeZone.getDefault();
        this.defaultHtmlEscape = null;
        this.dataValueProcessor = dataValueProcessor;
    }

    protected final ServerWebExchange getExchange() {
        return this.exchange;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public Map<String, Object> getModel() {
        return this.model;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void changeLocale(Locale locale) {
        this.locale = locale;
    }

    public void changeLocale(Locale locale, TimeZone timeZone) {
        this.locale = locale;
        this.timeZone = timeZone;
    }

    public void setDefaultHtmlEscape(boolean defaultHtmlEscape) {
        this.defaultHtmlEscape = defaultHtmlEscape;
    }

    public boolean isDefaultHtmlEscape() {
        return this.defaultHtmlEscape != null && this.defaultHtmlEscape != false;
    }

    public Boolean getDefaultHtmlEscape() {
        return this.defaultHtmlEscape;
    }

    public Optional<RequestDataValueProcessor> getRequestDataValueProcessor() {
        return Optional.ofNullable(this.dataValueProcessor);
    }

    public String getContextPath() {
        return this.exchange.getRequest().getContextPath();
    }

    public String getContextUrl(String relativeUrl) {
        String url = this.getContextPath() + relativeUrl;
        return this.getExchange().getResponse().encodeUrl(url);
    }

    public String getContextUrl(String relativeUrl, Map<String, ?> params) {
        String url = this.getContextPath() + relativeUrl;
        UriTemplate template = new UriTemplate(url);
        url = template.expand(params).toASCIIString();
        return this.getExchange().getResponse().encodeUrl(url);
    }

    public String getRequestPath() {
        return this.exchange.getRequest().getURI().getPath();
    }

    public String getQueryString() {
        return this.exchange.getRequest().getURI().getQuery();
    }

    public String getMessage(String code, String defaultMessage) {
        return this.getMessage(code, null, defaultMessage, this.isDefaultHtmlEscape());
    }

    public String getMessage(String code, Object[] args, String defaultMessage) {
        return this.getMessage(code, args, defaultMessage, this.isDefaultHtmlEscape());
    }

    public String getMessage(String code, List<?> args, String defaultMessage) {
        return this.getMessage(code, args != null ? args.toArray() : null, defaultMessage, this.isDefaultHtmlEscape());
    }

    public String getMessage(String code, Object[] args, String defaultMessage, boolean htmlEscape) {
        String msg = this.messageSource.getMessage(code, args, defaultMessage, this.locale);
        return htmlEscape ? HtmlUtils.htmlEscape((String)msg) : msg;
    }

    public String getMessage(String code) throws NoSuchMessageException {
        return this.getMessage(code, null, this.isDefaultHtmlEscape());
    }

    public String getMessage(String code, Object[] args) throws NoSuchMessageException {
        return this.getMessage(code, args, this.isDefaultHtmlEscape());
    }

    public String getMessage(String code, List<?> args) throws NoSuchMessageException {
        return this.getMessage(code, args != null ? args.toArray() : null, this.isDefaultHtmlEscape());
    }

    public String getMessage(String code, Object[] args, boolean htmlEscape) throws NoSuchMessageException {
        String msg = this.messageSource.getMessage(code, args, this.locale);
        return htmlEscape ? HtmlUtils.htmlEscape((String)msg) : msg;
    }

    public String getMessage(MessageSourceResolvable resolvable) throws NoSuchMessageException {
        return this.getMessage(resolvable, this.isDefaultHtmlEscape());
    }

    public String getMessage(MessageSourceResolvable resolvable, boolean htmlEscape) throws NoSuchMessageException {
        String msg = this.messageSource.getMessage(resolvable, this.locale);
        return htmlEscape ? HtmlUtils.htmlEscape((String)msg) : msg;
    }

    public Optional<Errors> getErrors(String name) {
        return this.getErrors(name, this.isDefaultHtmlEscape());
    }

    public Optional<Errors> getErrors(String name, boolean htmlEscape) {
        Optional<Errors> optional;
        if (this.errorsMap == null) {
            this.errorsMap = new HashMap<String, Errors>();
        }
        optional = (optional = Optional.ofNullable(this.errorsMap.get(name))).isPresent() ? optional : this.getModelObject(BindingResult.MODEL_KEY_PREFIX + name);
        return optional.map(errors -> {
            if (errors instanceof BindException) {
                return ((BindException)errors).getBindingResult();
            }
            return errors;
        }).map(errors -> {
            if (htmlEscape && !(errors instanceof EscapedErrors)) {
                errors = new EscapedErrors(errors);
            } else if (!htmlEscape && errors instanceof EscapedErrors) {
                errors = ((EscapedErrors)errors).getSource();
            }
            this.errorsMap.put(name, (Errors)errors);
            return errors;
        });
    }

    protected <T> Optional<T> getModelObject(String modelName) {
        return Optional.ofNullable(this.model).map(model -> Optional.ofNullable(model.get(modelName))).orElse(this.exchange.getAttribute(modelName));
    }

    public BindStatus getBindStatus(String path) throws IllegalStateException {
        return new BindStatus(this, path, this.isDefaultHtmlEscape());
    }

    public BindStatus getBindStatus(String path, boolean htmlEscape) throws IllegalStateException {
        return new BindStatus(this, path, htmlEscape);
    }
}

