/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket;

import java.net.URI;
import java.security.Principal;
import java.util.Optional;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class HandshakeInfo {
    private final URI uri;
    private final Mono<Principal> principalMono;
    private final HttpHeaders headers;
    private final Optional<String> protocol;

    public HandshakeInfo(URI uri, HttpHeaders headers, Mono<Principal> principal, Optional<String> protocol) {
        Assert.notNull((Object)uri, (String)"URI is required.");
        Assert.notNull((Object)headers, (String)"HttpHeaders are required.");
        Assert.notNull(principal, (String)"Principal is required.");
        Assert.notNull(protocol, (String)"Sub-protocol is required.");
        this.uri = uri;
        this.headers = headers;
        this.principalMono = principal;
        this.protocol = protocol;
    }

    public URI getUri() {
        return this.uri;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Mono<Principal> getPrincipal() {
        return this.principalMono;
    }

    public Optional<String> getSubProtocol() {
        return this.protocol;
    }

    public String toString() {
        return "HandshakeInfo[uri=" + this.uri + ", headers=" + this.headers + "]";
    }
}

