/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.client;

import io.netty.buffer.ByteBufAllocator;
import java.net.URI;
import java.util.function.Consumer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.ReactorNettyWebSocketSession;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import org.springframework.web.reactive.socket.client.WebSocketClientSupport;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.client.HttpClient;
import reactor.ipc.netty.http.client.HttpClientOptions;
import reactor.ipc.netty.http.client.HttpClientRequest;
import reactor.ipc.netty.http.client.HttpClientResponse;
import reactor.ipc.netty.http.websocket.WebsocketInbound;
import reactor.ipc.netty.http.websocket.WebsocketOutbound;

public class ReactorNettyWebSocketClient
extends WebSocketClientSupport
implements WebSocketClient {
    private final HttpClient httpClient;

    public ReactorNettyWebSocketClient() {
        this(options -> {});
    }

    public ReactorNettyWebSocketClient(Consumer<? super HttpClientOptions> clientOptions) {
        this.httpClient = HttpClient.create(clientOptions);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public Mono<Void> execute(URI url, WebSocketHandler handler) {
        return this.execute(url, new HttpHeaders(), handler);
    }

    @Override
    public Mono<Void> execute(URI url, HttpHeaders headers, WebSocketHandler handler) {
        String[] protocols = this.beforeHandshake(url, headers, handler);
        return this.getHttpClient().get(url.toString(), request -> this.addHeaders((HttpClientRequest)request, headers).sendWebsocket()).then(response -> {
            HandshakeInfo info = this.afterHandshake(url, this.toHttpHeaders((HttpClientResponse)response));
            ByteBufAllocator allocator = response.channel().alloc();
            NettyDataBufferFactory factory = new NettyDataBufferFactory(allocator);
            return response.receiveWebsocket((in, out) -> {
                ReactorNettyWebSocketSession session = new ReactorNettyWebSocketSession((WebsocketInbound)in, (WebsocketOutbound)out, info, factory);
                return handler.handle(session);
            });
        });
    }

    private HttpClientRequest addHeaders(HttpClientRequest request, HttpHeaders headers) {
        headers.keySet().stream().forEach(key -> request.requestHeaders().set(key, (Iterable)headers.get(key)));
        return request;
    }

    private HttpHeaders toHttpHeaders(HttpClientResponse response) {
        HttpHeaders headers = new HttpHeaders();
        response.responseHeaders().forEach(entry -> {
            String name = (String)entry.getKey();
            headers.put(name, response.responseHeaders().getAll(name));
        });
        return headers;
    }
}

