/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.server.upgrade;

import io.reactivex.netty.protocol.http.HttpHandlerNames;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.reactivex.netty.protocol.http.ws.server.WebSocketHandshaker;
import java.security.Principal;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.server.reactive.RxNettyServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.RxNettyWebSocketSession;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import rx.Observable;
import rx.RxReactiveStreams;

public class RxNettyRequestUpgradeStrategy
implements RequestUpgradeStrategy {
    @Override
    public Mono<Void> upgrade(ServerWebExchange exchange, WebSocketHandler handler, Optional<String> subProtocol) {
        RxNettyServerHttpResponse response = (RxNettyServerHttpResponse)exchange.getResponse();
        HttpServerResponse rxNettyResponse = response.getRxNettyResponse();
        HandshakeInfo info = this.getHandshakeInfo(exchange, subProtocol);
        NettyDataBufferFactory factory = (NettyDataBufferFactory)response.bufferFactory();
        WebSocketHandshaker handshaker = rxNettyResponse.acceptWebSocketUpgrade(conn -> {
            RxNettyWebSocketSession session = new RxNettyWebSocketSession(conn, info, factory);
            String name = HttpHandlerNames.WsServerDecoder.getName();
            session.aggregateFrames(rxNettyResponse.unsafeNettyChannel(), name);
            return RxReactiveStreams.toObservable(handler.handle(session));
        });
        handshaker = subProtocol.isPresent() ? handshaker.subprotocol(new String[]{subProtocol.get()}) : handshaker.subprotocol(new String[0]);
        return Mono.from((Publisher)RxReactiveStreams.toPublisher((Observable)handshaker));
    }

    private HandshakeInfo getHandshakeInfo(ServerWebExchange exchange, Optional<String> protocol) {
        ServerHttpRequest request = exchange.getRequest();
        Mono principal = exchange.getPrincipal();
        return new HandshakeInfo(request.getURI(), request.getHeaders(), (Mono<Principal>)principal, protocol);
    }
}

