/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.core.CollectionFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHeaders
implements MultiValueMap<String, String> {
    private static String ACCEPT = "Accept";
    private static String ACCEPT_CHARSET = "Accept-Charset";
    private static String ALLOW = "Allow";
    private static String CONTENT_LENGTH = "Content-Length";
    private static String CONTENT_TYPE = "Content-Type";
    private static String LOCATION = "Location";
    private final Map<String, List<String>> headers = CollectionFactory.createLinkedCaseInsensitiveMapIfPossible((int)5);

    public void setAccept(List<MediaType> acceptableMediaTypes) {
        this.set(ACCEPT, MediaType.toString(acceptableMediaTypes));
    }

    public List<MediaType> getAccept() {
        String value = this.getFirst(ACCEPT);
        return value != null ? MediaType.parseMediaTypes(value) : Collections.emptyList();
    }

    public void setAcceptCharset(List<Charset> acceptableCharsets) {
        StringBuilder builder = new StringBuilder();
        Iterator<Charset> iterator = acceptableCharsets.iterator();
        while (iterator.hasNext()) {
            Charset charset = iterator.next();
            builder.append(charset.name().toLowerCase(Locale.ENGLISH));
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        this.set(ACCEPT_CHARSET, builder.toString());
    }

    public List<Charset> getAcceptCharset() {
        ArrayList<Charset> result = new ArrayList<Charset>();
        String value = this.getFirst(ACCEPT_CHARSET);
        if (value != null) {
            String[] tokens;
            String[] stringArray = tokens = value.split(",\\s*");
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                int paramIdx = token.indexOf(59);
                if (paramIdx == -1) {
                    result.add(Charset.forName(token));
                } else {
                    result.add(Charset.forName(token.substring(0, paramIdx)));
                }
                ++n2;
            }
        }
        return result;
    }

    public void setAllow(Set<HttpMethod> allowedMethods) {
        this.set(ALLOW, StringUtils.collectionToCommaDelimitedString(allowedMethods));
    }

    public Set<HttpMethod> getAllow() {
        String value = this.getFirst(ALLOW);
        if (value != null) {
            String[] tokens;
            ArrayList<HttpMethod> allowedMethod = new ArrayList<HttpMethod>(5);
            String[] stringArray = tokens = value.split(",\\s*");
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                allowedMethod.add(HttpMethod.valueOf(token));
                ++n2;
            }
            return EnumSet.copyOf(allowedMethod);
        }
        return EnumSet.noneOf(HttpMethod.class);
    }

    public void setContentLength(long contentLength) {
        this.set(CONTENT_LENGTH, Long.toString(contentLength));
    }

    public long getContentLength() {
        String value = this.getFirst(CONTENT_LENGTH);
        return value != null ? Long.parseLong(value) : -1L;
    }

    public void setContentType(MediaType mediaType) {
        Assert.isTrue((!mediaType.isWildcardType() ? 1 : 0) != 0, (String)"'Content-Type' cannot contain wildcard type '*'");
        Assert.isTrue((!mediaType.isWildcardSubtype() ? 1 : 0) != 0, (String)"'Content-Type' cannot contain wildcard subtype '*'");
        this.set(CONTENT_TYPE, mediaType.toString());
    }

    public MediaType getContentType() {
        String value = this.getFirst(CONTENT_TYPE);
        return value != null ? MediaType.parseMediaType(value) : null;
    }

    public void setLocation(URI location) {
        this.set(LOCATION, location.toASCIIString());
    }

    public URI getLocation() {
        String value = this.getFirst(LOCATION);
        return value != null ? URI.create(value) : null;
    }

    public String getFirst(String headerName) {
        List<String> headerValues = this.headers.get(headerName);
        return headerValues != null ? headerValues.get(0) : null;
    }

    public void add(String headerName, String headerValue) {
        List<String> headerValues = this.headers.get(headerName);
        if (headerValues == null) {
            headerValues = new LinkedList<String>();
            this.headers.put(headerName, headerValues);
        }
        headerValues.add(headerValue);
    }

    public void set(String headerName, String headerValue) {
        LinkedList<String> headerValues = new LinkedList<String>();
        headerValues.add(headerValue);
        this.headers.put(headerName, headerValues);
    }

    public int size() {
        return this.headers.size();
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.headers.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.headers.containsValue(value);
    }

    public List<String> get(Object key) {
        return this.headers.get(key);
    }

    public List<String> put(String key, List<String> value) {
        return this.headers.put(key, value);
    }

    public List<String> remove(Object key) {
        return this.headers.remove(key);
    }

    public void putAll(Map<? extends String, ? extends List<String>> m) {
        this.headers.putAll(m);
    }

    public void clear() {
        this.headers.clear();
    }

    public Set<String> keySet() {
        return this.headers.keySet();
    }

    public Collection<List<String>> values() {
        return this.headers.values();
    }

    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.headers.entrySet();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpHeaders)) {
            return false;
        }
        HttpHeaders otherHeaders = (HttpHeaders)other;
        return this.headers.equals(otherHeaders.headers);
    }

    public int hashCode() {
        return this.headers.hashCode();
    }

    public String toString() {
        return this.headers.toString();
    }
}

