/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.util.FileCopyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringHttpMessageConverter
extends AbstractHttpMessageConverter<String> {
    public static final Charset DEFAULT_CHARSET = Charset.forName("ISO-8859-1");
    private final List<Charset> availableCharsets = new ArrayList<Charset>(Charset.availableCharsets().values());

    public StringHttpMessageConverter() {
        super(new MediaType("text", "plain", DEFAULT_CHARSET), new MediaType("text", "*"));
    }

    @Override
    public boolean supports(Class<? extends String> clazz) {
        return String.class.equals(clazz);
    }

    @Override
    public String readInternal(Class<String> clazz, HttpInputMessage inputMessage) throws IOException {
        MediaType contentType = inputMessage.getHeaders().getContentType();
        Charset charset = contentType.getCharSet() != null ? contentType.getCharSet() : DEFAULT_CHARSET;
        return FileCopyUtils.copyToString((Reader)new InputStreamReader(inputMessage.getBody(), charset));
    }

    @Override
    protected Long getContentLength(String s) {
        Charset charset = this.getContentType(s).getCharSet();
        if (charset != null) {
            try {
                return s.getBytes(charset.name()).length;
            }
            catch (UnsupportedEncodingException ex) {
                throw new InternalError(ex.getMessage());
            }
        }
        return null;
    }

    @Override
    protected void writeInternal(String s, HttpOutputMessage outputMessage) throws IOException {
        outputMessage.getHeaders().setAcceptCharset(this.getAcceptedCharsets());
        MediaType contentType = this.getContentType(s);
        Charset charset = contentType.getCharSet() != null ? contentType.getCharSet() : DEFAULT_CHARSET;
        FileCopyUtils.copy((String)s, (Writer)new OutputStreamWriter(outputMessage.getBody(), charset));
    }

    protected List<Charset> getAcceptedCharsets() {
        return this.availableCharsets;
    }
}

