/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.caucho;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.HessianDebugInputStream;
import com.caucho.hessian.io.HessianDebugOutputStream;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.SerializerFactory;
import com.caucho.hessian.server.HessianSkeleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.support.RemoteExporter;
import org.springframework.util.Assert;
import org.springframework.util.CommonsLogWriter;

public class HessianExporter
extends RemoteExporter
implements InitializingBean {
    public static final String CONTENT_TYPE_HESSIAN = "application/x-hessian";
    private SerializerFactory serializerFactory = new SerializerFactory();
    private Log debugLogger;
    private HessianSkeleton skeleton;

    public void setSerializerFactory(SerializerFactory serializerFactory) {
        this.serializerFactory = serializerFactory != null ? serializerFactory : new SerializerFactory();
    }

    public void setSendCollectionType(boolean sendCollectionType) {
        this.serializerFactory.setSendCollectionType(sendCollectionType);
    }

    public void setDebug(boolean debug) {
        this.debugLogger = debug ? this.logger : null;
    }

    public void afterPropertiesSet() {
        this.prepare();
    }

    public void prepare() {
        this.checkService();
        this.checkServiceInterface();
        this.skeleton = new HessianSkeleton(this.getProxyForService(), this.getServiceInterface());
    }

    public void invoke(InputStream inputStream, OutputStream outputStream) throws Throwable {
        Assert.notNull((Object)this.skeleton, (String)"Hessian exporter has not been initialized");
        ClassLoader originalClassLoader = this.overrideThreadContextClassLoader();
        try {
            this.doInvoke(inputStream, outputStream);
        }
        finally {
            this.resetThreadContextClassLoader(originalClassLoader);
        }
    }

    public void doInvoke(InputStream inputStream, OutputStream outputStream) throws Throwable {
        Object out;
        Hessian2Input in;
        int code;
        InputStream isToUse = inputStream;
        OutputStream osToUse = outputStream;
        if (this.debugLogger != null && this.debugLogger.isDebugEnabled()) {
            PrintWriter debugWriter = new PrintWriter((Writer)new CommonsLogWriter(this.debugLogger));
            isToUse = new HessianDebugInputStream(inputStream, debugWriter);
            osToUse = new HessianDebugOutputStream(outputStream, debugWriter);
        }
        if ((code = isToUse.read()) == 72) {
            int major = isToUse.read();
            int minor = isToUse.read();
            if (major != 2) {
                throw new IOException("Version " + major + "." + minor + " is not understood");
            }
            in = new Hessian2Input(isToUse);
            out = new Hessian2Output(osToUse);
            in.readCall();
        } else if (code == 99) {
            int major = isToUse.read();
            int minor = isToUse.read();
            in = new HessianInput(isToUse);
            out = major >= 2 ? new Hessian2Output(osToUse) : new HessianOutput(osToUse);
        } else {
            throw new IOException("Expected 'H' (Hessian 2.0) or 'c' (Hessian 1.0) in hessian input at " + code);
        }
        if (this.serializerFactory != null) {
            in.setSerializerFactory(this.serializerFactory);
            out.setSerializerFactory(this.serializerFactory);
        }
        try {
            this.skeleton.invoke((AbstractHessianInput)in, (AbstractHessianOutput)out);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                isToUse.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
                osToUse.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
            isToUse.close();
        }
        catch (IOException iOException) {}
        try {
            out.close();
            osToUse.close();
        }
        catch (IOException iOException) {}
    }
}

