/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.jaxws;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.jws.WebService;
import javax.xml.ws.Endpoint;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJaxWsServiceExporter
implements BeanFactoryAware,
InitializingBean,
DisposableBean {
    private Map<String, Object> endpointProperties;
    private Executor executor;
    private ListableBeanFactory beanFactory;
    private final Set<Endpoint> publishedEndpoints = new LinkedHashSet<Endpoint>();

    public void setEndpointProperties(Map<String, Object> endpointProperties) {
        this.endpointProperties = endpointProperties;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof ListableBeanFactory)) {
            throw new IllegalStateException(String.valueOf(this.getClass().getSimpleName()) + " requires a ListableBeanFactory");
        }
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        this.publishEndpoints();
    }

    public void publishEndpoints() {
        String[] beanNames;
        String[] stringArray = beanNames = this.beanFactory.getBeanNamesForType(Object.class, false, false);
        int n = beanNames.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            Class type = this.beanFactory.getType(beanName);
            WebService annotation = type.getAnnotation(WebService.class);
            if (annotation != null) {
                Endpoint endpoint = Endpoint.create((Object)this.beanFactory.getBean(beanName));
                if (this.endpointProperties != null) {
                    endpoint.setProperties(this.endpointProperties);
                }
                if (this.executor != null) {
                    endpoint.setExecutor(this.executor);
                }
                this.publishEndpoint(endpoint, annotation);
                this.publishedEndpoints.add(endpoint);
            }
            ++n2;
        }
    }

    protected abstract void publishEndpoint(Endpoint var1, WebService var2);

    public void destroy() {
        for (Endpoint endpoint : this.publishedEndpoints) {
            endpoint.stop();
        }
    }
}

