/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.support.HttpAccessor;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestTemplate
extends HttpAccessor
implements RestOperations {
    private final ResponseExtractor<HttpHeaders> headersExtractor = new HeadersExtractor();
    private HttpMessageConverter<?>[] messageConverters = new HttpMessageConverter[]{new ByteArrayHttpMessageConverter(), new StringHttpMessageConverter(), new FormHttpMessageConverter(), new SourceHttpMessageConverter()};
    private ResponseErrorHandler errorHandler = new DefaultResponseErrorHandler();

    public RestTemplate() {
    }

    public RestTemplate(ClientHttpRequestFactory requestFactory) {
        this.setRequestFactory(requestFactory);
    }

    public void setMessageConverters(HttpMessageConverter<?>[] messageConverters) {
        Assert.notEmpty((Object[])messageConverters, (String)"'messageConverters' must not be empty");
        this.messageConverters = messageConverters;
    }

    public HttpMessageConverter<?>[] getMessageConverters() {
        return this.messageConverters;
    }

    protected <T> List<HttpMessageConverter<T>> getSupportedMessageConverters(Class<T> type) {
        HttpMessageConverter<?>[] converters = this.getMessageConverters();
        ArrayList<HttpMessageConverter<T>> result = new ArrayList<HttpMessageConverter<T>>(converters.length);
        HttpMessageConverter<?>[] httpMessageConverterArray = converters;
        int n = converters.length;
        int n2 = 0;
        while (n2 < n) {
            HttpMessageConverter<?> converter = httpMessageConverterArray[n2];
            if (converter.supports(type)) {
                result.add(converter);
            }
            ++n2;
        }
        return result;
    }

    public void setErrorHandler(ResponseErrorHandler errorHandler) {
        Assert.notNull((Object)errorHandler, (String)"'errorHandler' must not be null");
        this.errorHandler = errorHandler;
    }

    public ResponseErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public <T> T getForObject(String url, Class<T> responseType, String ... urlVariables) throws RestClientException {
        this.checkForSupportedMessageConverter(responseType);
        return this.execute(url, HttpMethod.GET, new GetCallback(responseType), new HttpMessageConverterExtractor(responseType), urlVariables);
    }

    @Override
    public <T> T getForObject(String url, Class<T> responseType, Map<String, String> urlVariables) throws RestClientException {
        this.checkForSupportedMessageConverter(responseType);
        return this.execute(url, HttpMethod.GET, new GetCallback(responseType), new HttpMessageConverterExtractor(responseType), urlVariables);
    }

    @Override
    public HttpHeaders headForHeaders(String url, String ... urlVariables) throws RestClientException {
        return this.execute(url, HttpMethod.HEAD, null, this.headersExtractor, urlVariables);
    }

    @Override
    public HttpHeaders headForHeaders(String url, Map<String, String> urlVariables) throws RestClientException {
        return this.execute(url, HttpMethod.HEAD, null, this.headersExtractor, urlVariables);
    }

    @Override
    public URI postForLocation(String url, Object request, String ... urlVariables) throws RestClientException {
        if (request != null) {
            this.checkForSupportedMessageConverter(request.getClass());
        }
        HttpHeaders headers = this.execute(url, HttpMethod.POST, (RequestCallback)new PostPutCallback(request), this.headersExtractor, urlVariables);
        return headers.getLocation();
    }

    @Override
    public URI postForLocation(String url, Object request, Map<String, String> urlVariables) throws RestClientException {
        if (request != null) {
            this.checkForSupportedMessageConverter(request.getClass());
        }
        HttpHeaders headers = this.execute(url, HttpMethod.POST, (RequestCallback)new PostPutCallback(request), this.headersExtractor, urlVariables);
        return headers.getLocation();
    }

    @Override
    public void put(String url, Object request, String ... urlVariables) throws RestClientException {
        if (request != null) {
            this.checkForSupportedMessageConverter(request.getClass());
        }
        this.execute(url, HttpMethod.PUT, (RequestCallback)new PostPutCallback(request), null, urlVariables);
    }

    @Override
    public void put(String url, Object request, Map<String, String> urlVariables) throws RestClientException {
        if (request != null) {
            this.checkForSupportedMessageConverter(request.getClass());
        }
        this.execute(url, HttpMethod.PUT, (RequestCallback)new PostPutCallback(request), null, urlVariables);
    }

    @Override
    public void delete(String url, String ... urlVariables) throws RestClientException {
        this.execute(url, HttpMethod.DELETE, null, null, urlVariables);
    }

    @Override
    public void delete(String url, Map<String, String> urlVariables) throws RestClientException {
        this.execute(url, HttpMethod.DELETE, null, null, urlVariables);
    }

    @Override
    public Set<HttpMethod> optionsForAllow(String url, String ... urlVariables) throws RestClientException {
        HttpHeaders headers = this.execute(url, HttpMethod.OPTIONS, null, this.headersExtractor, urlVariables);
        return headers.getAllow();
    }

    @Override
    public Set<HttpMethod> optionsForAllow(String url, Map<String, String> urlVariables) throws RestClientException {
        HttpHeaders headers = this.execute(url, HttpMethod.OPTIONS, null, this.headersExtractor, urlVariables);
        return headers.getAllow();
    }

    @Override
    public <T> T execute(String url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor, String ... urlVariables) throws RestClientException {
        UriTemplate uriTemplate = new UriTemplate(url);
        URI expanded = uriTemplate.expand(urlVariables);
        return this.doExecute(expanded, method, requestCallback, responseExtractor);
    }

    @Override
    public <T> T execute(String url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor, Map<String, String> urlVariables) throws RestClientException {
        UriTemplate uriTemplate = new UriTemplate(url);
        URI expanded = uriTemplate.expand(urlVariables);
        return this.doExecute(expanded, method, requestCallback, responseExtractor);
    }

    protected <T> T doExecute(URI url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        Assert.notNull((Object)url, (String)"'url' must not be null");
        Assert.notNull((Object)((Object)method), (String)"'method' must not be null");
        ClientHttpResponse response = null;
        try {
            ClientHttpRequest request = this.createRequest(url, method);
            if (requestCallback != null) {
                requestCallback.doWithRequest(request);
            }
            response = request.execute();
            if (this.getErrorHandler().hasError(response)) {
                this.getErrorHandler().handleError(response);
            }
            if (responseExtractor != null) {
                T t = responseExtractor.extractData(response);
                return t;
            }
            return null;
        }
        catch (IOException ex) {
            throw new ResourceAccessException("I/O error: " + ex.getMessage(), ex);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    private void checkForSupportedMessageConverter(Class type) {
        HttpMessageConverter<?>[] httpMessageConverterArray = this.getMessageConverters();
        int n = httpMessageConverterArray.length;
        int n2 = 0;
        while (n2 < n) {
            HttpMessageConverter<?> entityConverter = httpMessageConverterArray[n2];
            if (entityConverter.supports(type)) {
                return;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Could not resolve HttpMessageConverter for [" + type.getName() + "]");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetCallback<T>
    implements RequestCallback {
        private final Class<T> responseType;

        private GetCallback(Class<T> responseType) {
            this.responseType = responseType;
        }

        @Override
        public void doWithRequest(ClientHttpRequest request) throws IOException {
            ArrayList<MediaType> allSupportedMediaTypes = new ArrayList<MediaType>();
            for (HttpMessageConverter<T> entityConverter : RestTemplate.this.getSupportedMessageConverters(this.responseType)) {
                List<MediaType> supportedMediaTypes = entityConverter.getSupportedMediaTypes();
                for (MediaType supportedMediaType : supportedMediaTypes) {
                    if (supportedMediaType.getCharSet() != null) {
                        supportedMediaType = new MediaType(supportedMediaType.getType(), supportedMediaType.getSubtype());
                    }
                    allSupportedMediaTypes.add(supportedMediaType);
                }
            }
            Collections.sort(allSupportedMediaTypes);
            request.getHeaders().setAccept(allSupportedMediaTypes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HeadersExtractor
    implements ResponseExtractor<HttpHeaders> {
        private HeadersExtractor() {
        }

        @Override
        public HttpHeaders extractData(ClientHttpResponse response) throws IOException {
            return response.getHeaders();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HttpMessageConverterExtractor<T>
    implements ResponseExtractor<T> {
        private final Class<T> responseType;

        private HttpMessageConverterExtractor(Class<T> responseType) {
            this.responseType = responseType;
        }

        @Override
        public T extractData(ClientHttpResponse response) throws IOException {
            MediaType contentType = response.getHeaders().getContentType();
            if (contentType == null) {
                throw new RestClientException("Cannot extract response: no Content-Type found");
            }
            for (HttpMessageConverter<T> messageConverter : RestTemplate.this.getSupportedMessageConverters(this.responseType)) {
                for (MediaType supportedMediaType : messageConverter.getSupportedMediaTypes()) {
                    if (!supportedMediaType.includes(contentType)) continue;
                    return messageConverter.read(this.responseType, response);
                }
            }
            throw new RestClientException("Could not extract response: no suitable HttpMessageConverter found for response type [" + this.responseType.getName() + "] and content type [" + contentType + "]");
        }
    }

    private class PostPutCallback
    implements RequestCallback {
        private final Object request;

        private PostPutCallback(Object request) {
            this.request = request;
        }

        public void doWithRequest(ClientHttpRequest httpRequest) throws IOException {
            if (this.request != null) {
                HttpMessageConverter<?> entityConverter = RestTemplate.this.getSupportedMessageConverters(this.request.getClass()).get(0);
                entityConverter.write(this.request, httpRequest);
            } else {
                httpRequest.getHeaders().setContentLength(0L);
            }
        }
    }
}

