/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.Md5HashUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class ShallowEtagHeaderFilter
extends OncePerRequestFilter {
    private static String HEADER_ETAG = "ETag";
    private static String HEADER_IF_NONE_MATCH = "If-None-Match";

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        ShallowEtagResponseWrapper responseWrapper = new ShallowEtagResponseWrapper(response);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)responseWrapper);
        byte[] body = responseWrapper.toByteArray();
        String responseETag = this.generateETagHeaderValue(body);
        response.setHeader(HEADER_ETAG, responseETag);
        String requestETag = request.getHeader(HEADER_IF_NONE_MATCH);
        if (responseETag.equals(requestETag)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("ETag [" + responseETag + "] equal to If-None-Match, sending 304"));
            }
            response.setStatus(304);
        } else {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("ETag [" + responseETag + "] not equal to If-None-Match [" + requestETag + "], sending normal response"));
            }
            response.setContentLength(body.length);
            FileCopyUtils.copy((byte[])body, (OutputStream)response.getOutputStream());
        }
    }

    protected String generateETagHeaderValue(byte[] bytes) {
        StringBuilder builder = new StringBuilder("\"0");
        Md5HashUtils.appendHashString((byte[])bytes, (StringBuilder)builder);
        builder.append('\"');
        return builder.toString();
    }

    private static class ShallowEtagResponseWrapper
    extends HttpServletResponseWrapper {
        private final ByteArrayOutputStream content = new ByteArrayOutputStream();
        private final ServletOutputStream outputStream = new ResponseServletOutputStream();
        private PrintWriter writer;

        private ShallowEtagResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public ServletOutputStream getOutputStream() {
            return this.outputStream;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.writer == null) {
                String characterEncoding = this.getCharacterEncoding();
                OutputStreamWriter targetWriter = characterEncoding != null ? new OutputStreamWriter((OutputStream)this.outputStream, characterEncoding) : new OutputStreamWriter((OutputStream)this.outputStream);
                this.writer = new PrintWriter(targetWriter);
            }
            return this.writer;
        }

        public void resetBuffer() {
            this.content.reset();
        }

        public void reset() {
            super.reset();
            this.resetBuffer();
        }

        private byte[] toByteArray() {
            return this.content.toByteArray();
        }

        private class ResponseServletOutputStream
        extends ServletOutputStream {
            private ResponseServletOutputStream() {
            }

            public void write(int b) throws IOException {
                ShallowEtagResponseWrapper.this.content.write(b);
            }
        }
    }
}

