/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.web.WebApplicationInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HandlesTypes(value={WebApplicationInitializer.class})
public class SpringServletContainerInitializer
implements ServletContainerInitializer {
    private static final Log logger = LogFactory.getLog(SpringServletContainerInitializer.class);

    public void onStartup(Set<Class<?>> webAppInitializerClasses, ServletContext servletContext) throws ServletException {
        ArrayList<WebApplicationInitializer> initializers = new ArrayList<WebApplicationInitializer>();
        for (Class<?> waiClass : webAppInitializerClasses) {
            if (Modifier.isAbstract(waiClass.getModifiers())) continue;
            initializers.add((WebApplicationInitializer)BeanUtils.instantiateClass(waiClass, WebApplicationInitializer.class));
        }
        if (initializers.isEmpty()) {
            logger.info((Object)"Detected no WebApplicationInitializer types on the classpath: exiting.");
            return;
        }
        Collections.sort(initializers, new AnnotationAwareOrderComparator());
        logger.info((Object)("Delegating ServletContext to the following WebApplicationInitializer instances: " + initializers));
        for (WebApplicationInitializer initializer : initializers) {
            initializer.onStartup(servletContext);
        }
    }
}

