/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Mono;

public abstract class AbstractClientHttpRequest
implements ClientHttpRequest {
    private final HttpHeaders headers;
    private final MultiValueMap<String, HttpCookie> cookies;
    private AtomicReference<State> state = new AtomicReference<State>(State.NEW);
    private final List<Supplier<? extends Mono<Void>>> beforeCommitActions = new ArrayList<Supplier<? extends Mono<Void>>>(4);

    public AbstractClientHttpRequest() {
        this(new HttpHeaders());
    }

    public AbstractClientHttpRequest(HttpHeaders headers) {
        Assert.notNull((Object)headers);
        this.headers = headers;
        this.cookies = new LinkedMultiValueMap();
    }

    @Override
    public HttpHeaders getHeaders() {
        if (State.COMITTED.equals((Object)this.state.get())) {
            return HttpHeaders.readOnlyHttpHeaders(this.headers);
        }
        return this.headers;
    }

    @Override
    public MultiValueMap<String, HttpCookie> getCookies() {
        if (State.COMITTED.equals((Object)this.state.get())) {
            return CollectionUtils.unmodifiableMultiValueMap(this.cookies);
        }
        return this.cookies;
    }

    protected Mono<Void> applyBeforeCommit() {
        Mono mono = Mono.empty();
        if (this.state.compareAndSet(State.NEW, State.COMMITTING)) {
            for (Supplier<? extends Mono<Void>> action : this.beforeCommitActions) {
                mono = mono.then(() -> (Mono)action.get());
            }
            return mono.otherwise(ex -> Mono.empty()).then(() -> {
                this.state.set(State.COMITTED);
                this.writeHeaders();
                this.writeCookies();
                return Mono.empty();
            });
        }
        return mono;
    }

    @Override
    public void beforeCommit(Supplier<? extends Mono<Void>> action) {
        Assert.notNull(action);
        this.beforeCommitActions.add(action);
    }

    protected abstract void writeHeaders();

    protected abstract void writeCookies();

    private static enum State {
        NEW,
        COMMITTING,
        COMITTED;

    }
}

