/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import com.fasterxml.jackson.annotation.JsonView;
import java.util.Collections;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.http.codec.AbstractServerHttpMessageReader;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.json.AbstractJackson2Codec;
import org.springframework.http.server.reactive.ServerHttpRequest;

public class Jackson2ServerHttpMessageReader
extends AbstractServerHttpMessageReader<Object> {
    public Jackson2ServerHttpMessageReader(HttpMessageReader<Object> reader) {
        super(reader);
    }

    @Override
    protected Map<String, Object> resolveReadHints(ResolvableType streamType, ResolvableType elementType, ServerHttpRequest request) {
        JsonView annotation;
        MethodParameter parameter;
        Object source = streamType.getSource();
        MethodParameter methodParameter = parameter = source instanceof MethodParameter ? (MethodParameter)source : null;
        if (parameter != null && (annotation = (JsonView)parameter.getParameterAnnotation(JsonView.class)) != null) {
            Class[] classes = annotation.value();
            if (classes.length != 1) {
                throw new IllegalArgumentException("@JsonView only supported for read hints with exactly 1 class argument: " + parameter);
            }
            return Collections.singletonMap(AbstractJackson2Codec.JSON_VIEW_HINT, classes[0]);
        }
        return Collections.emptyMap();
    }
}

