/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.CodecException;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.util.Assert;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ServerSentEventHttpMessageWriter
implements HttpMessageWriter<Object> {
    private static final MediaType TEXT_EVENT_STREAM = new MediaType("text", "event-stream");
    private final List<Encoder<?>> dataEncoders;

    public ServerSentEventHttpMessageWriter() {
        this.dataEncoders = Collections.emptyList();
    }

    public ServerSentEventHttpMessageWriter(List<Encoder<?>> dataEncoders) {
        Assert.notNull(dataEncoders, (String)"'dataEncoders' must not be null");
        this.dataEncoders = dataEncoders;
    }

    @Override
    public boolean canWrite(ResolvableType elementType, MediaType mediaType) {
        return mediaType == null || TEXT_EVENT_STREAM.isCompatibleWith(mediaType);
    }

    @Override
    public List<MediaType> getWritableMediaTypes() {
        return Collections.singletonList(TEXT_EVENT_STREAM);
    }

    @Override
    public Mono<Void> write(Publisher<?> inputStream, ResolvableType elementType, MediaType mediaType, ReactiveHttpOutputMessage outputMessage, Map<String, Object> hints) {
        outputMessage.getHeaders().setContentType(TEXT_EVENT_STREAM);
        DataBufferFactory bufferFactory = outputMessage.bufferFactory();
        Flux<Publisher<DataBuffer>> body = this.encode(inputStream, bufferFactory, elementType, hints);
        return outputMessage.writeAndFlushWith((Publisher<Publisher<DataBuffer>>)body);
    }

    private Flux<Publisher<DataBuffer>> encode(Publisher<?> inputStream, DataBufferFactory bufferFactory, ResolvableType type, Map<String, Object> hints) {
        return Flux.from(inputStream).map(o -> this.toSseEvent(o, type)).map(sse -> {
            StringBuilder sb = new StringBuilder();
            sse.id().ifPresent(id -> this.writeField("id", id, sb));
            sse.event().ifPresent(event -> this.writeField("event", event, sb));
            sse.retry().ifPresent(retry -> this.writeField("retry", retry.toMillis(), sb));
            sse.comment().ifPresent(comment -> {
                comment = comment.replaceAll("\\n", "\n:");
                sb.append(':').append((String)comment).append("\n");
            });
            Flux dataBuffer = sse.data().map(data -> {
                sb.append("data:");
                if (data instanceof String) {
                    String stringData = ((String)data).replaceAll("\\n", "\ndata:");
                    sb.append(stringData).append('\n');
                    return Flux.empty();
                }
                return this.applyEncoder(data, bufferFactory, hints);
            }).orElse(Flux.empty());
            return Flux.concat((Publisher[])new Publisher[]{this.encodeString(sb.toString(), bufferFactory), dataBuffer, this.encodeString("\n", bufferFactory)});
        });
    }

    private ServerSentEvent<?> toSseEvent(Object data, ResolvableType type) {
        return ServerSentEvent.class.isAssignableFrom(type.getRawClass()) ? (ServerSentEvent<Object>)data : ServerSentEvent.builder().data(data).build();
    }

    private void writeField(String fieldName, Object fieldValue, StringBuilder stringBuilder) {
        stringBuilder.append(fieldName);
        stringBuilder.append(':');
        stringBuilder.append(fieldValue.toString());
        stringBuilder.append("\n");
    }

    private <T> Flux<DataBuffer> applyEncoder(Object data, DataBufferFactory bufferFactory, Map<String, Object> hints) {
        ResolvableType elementType = ResolvableType.forClass(data.getClass());
        Optional<Encoder> encoder = this.dataEncoders.stream().filter(e -> e.canEncode(elementType, MimeTypeUtils.APPLICATION_JSON)).findFirst();
        return encoder.orElseThrow(() -> new CodecException("No suitable encoder found!")).encode((Publisher)Mono.just((Object)data), bufferFactory, elementType, MimeTypeUtils.APPLICATION_JSON, hints).concatWith(this.encodeString("\n", bufferFactory));
    }

    private Mono<DataBuffer> encodeString(String str, DataBufferFactory bufferFactory) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        DataBuffer buffer = bufferFactory.allocateBuffer(bytes.length).write(bytes);
        return Mono.just((Object)buffer);
    }
}

