/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Operators;

class ResponseBodyWriteResultPublisher
implements Publisher<Void> {
    private static final Log logger = LogFactory.getLog(ResponseBodyWriteResultPublisher.class);
    private final AtomicReference<State> state = new AtomicReference<State>(State.UNSUBSCRIBED);
    private Subscriber<? super Void> subscriber;
    private volatile boolean publisherCompleted;
    private volatile Throwable publisherError;

    ResponseBodyWriteResultPublisher() {
    }

    public final void subscribe(Subscriber<? super Void> subscriber) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(this.state + " subscribe: " + subscriber));
        }
        this.state.get().subscribe(this, subscriber);
    }

    private boolean changeState(State oldState, State newState) {
        return this.state.compareAndSet(oldState, newState);
    }

    public void publishComplete() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(this.state + " publishComplete"));
        }
        this.state.get().publishComplete(this);
    }

    public void publishError(Throwable t) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(this.state + " publishError: " + t));
        }
        this.state.get().publishError(this, t);
    }

    private static enum State {
        UNSUBSCRIBED{

            @Override
            void subscribe(ResponseBodyWriteResultPublisher publisher, Subscriber<? super Void> subscriber) {
                Objects.requireNonNull(subscriber);
                if (publisher.changeState(this, 1.SUBSCRIBED)) {
                    ResponseBodyWriteResultSubscription subscription = new ResponseBodyWriteResultSubscription(publisher);
                    publisher.subscriber = subscriber;
                    subscriber.onSubscribe((Subscription)subscription);
                    if (publisher.publisherCompleted) {
                        publisher.publishComplete();
                    } else if (publisher.publisherError != null) {
                        publisher.publishError(publisher.publisherError);
                    }
                } else {
                    throw new IllegalStateException(this.toString());
                }
            }

            @Override
            void publishComplete(ResponseBodyWriteResultPublisher publisher) {
                publisher.publisherCompleted = true;
            }

            @Override
            void publishError(ResponseBodyWriteResultPublisher publisher, Throwable t) {
                publisher.publisherError = t;
            }
        }
        ,
        SUBSCRIBED{

            @Override
            void request(ResponseBodyWriteResultPublisher publisher, long n) {
                Operators.checkRequest((long)n, (Subscriber)publisher.subscriber);
            }

            @Override
            void publishComplete(ResponseBodyWriteResultPublisher publisher) {
                if (publisher.changeState(this, 2.COMPLETED)) {
                    publisher.subscriber.onComplete();
                }
            }

            @Override
            void publishError(ResponseBodyWriteResultPublisher publisher, Throwable t) {
                if (publisher.changeState(this, 2.COMPLETED)) {
                    publisher.subscriber.onError(t);
                }
            }
        }
        ,
        COMPLETED{

            @Override
            void request(ResponseBodyWriteResultPublisher publisher, long n) {
            }

            @Override
            void cancel(ResponseBodyWriteResultPublisher publisher) {
            }

            @Override
            void publishComplete(ResponseBodyWriteResultPublisher publisher) {
            }

            @Override
            void publishError(ResponseBodyWriteResultPublisher publisher, Throwable t) {
            }
        };


        void subscribe(ResponseBodyWriteResultPublisher publisher, Subscriber<? super Void> subscriber) {
            throw new IllegalStateException(this.toString());
        }

        void request(ResponseBodyWriteResultPublisher publisher, long n) {
            throw new IllegalStateException(this.toString());
        }

        void cancel(ResponseBodyWriteResultPublisher publisher) {
            publisher.changeState(this, State.COMPLETED);
        }

        void publishComplete(ResponseBodyWriteResultPublisher publisher) {
            throw new IllegalStateException(this.toString());
        }

        void publishError(ResponseBodyWriteResultPublisher publisher, Throwable t) {
            throw new IllegalStateException(this.toString());
        }
    }

    private static final class ResponseBodyWriteResultSubscription
    implements Subscription {
        private final ResponseBodyWriteResultPublisher publisher;

        public ResponseBodyWriteResultSubscription(ResponseBodyWriteResultPublisher publisher) {
            this.publisher = publisher;
        }

        public final void request(long n) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)((Object)((Object)this.state()) + " request: " + n));
            }
            this.state().request(this.publisher, n);
        }

        public final void cancel() {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)((Object)((Object)this.state()) + " cancel"));
            }
            this.state().cancel(this.publisher);
        }

        private State state() {
            return (State)((Object)this.publisher.state.get());
        }
    }
}

