/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.reactivex.netty.protocol.http.server.RequestHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.RxNettyServerHttpRequest;
import org.springframework.http.server.reactive.RxNettyServerHttpResponse;
import org.springframework.util.Assert;
import reactor.adapter.RxJava1Adapter;
import reactor.core.publisher.Mono;
import rx.Observable;

public class RxNettyHttpHandlerAdapter
implements RequestHandler<ByteBuf, ByteBuf> {
    private static Log logger = LogFactory.getLog(RxNettyHttpHandlerAdapter.class);
    private final HttpHandler delegate;

    public RxNettyHttpHandlerAdapter(HttpHandler delegate) {
        Assert.notNull((Object)delegate, (String)"HttpHandler delegate is required");
        this.delegate = delegate;
    }

    public Observable<Void> handle(HttpServerRequest<ByteBuf> request, HttpServerResponse<ByteBuf> response) {
        NettyDataBufferFactory bufferFactory = new NettyDataBufferFactory(response.unsafeNettyChannel().alloc());
        RxNettyServerHttpRequest adaptedRequest = new RxNettyServerHttpRequest(request, bufferFactory);
        RxNettyServerHttpResponse adaptedResponse = new RxNettyServerHttpResponse(response, bufferFactory);
        Mono result = this.delegate.handle(adaptedRequest, adaptedResponse).otherwise(ex -> {
            logger.debug((Object)"Could not complete request", ex);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            return Mono.empty();
        }).doOnSuccess(aVoid -> logger.debug((Object)"Successfully completed request"));
        return RxJava1Adapter.publisherToObservable((Publisher)result);
    }
}

