/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.undertow.server.HttpServerExchange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.UndertowServerHttpRequest;
import org.springframework.http.server.reactive.UndertowServerHttpResponse;
import org.springframework.util.Assert;

public class UndertowHttpHandlerAdapter
implements io.undertow.server.HttpHandler {
    private static Log logger = LogFactory.getLog(UndertowHttpHandlerAdapter.class);
    private final HttpHandler delegate;
    private DataBufferFactory dataBufferFactory = new DefaultDataBufferFactory(false);

    public UndertowHttpHandlerAdapter(HttpHandler delegate) {
        Assert.notNull((Object)delegate, (String)"HttpHandler delegate is required");
        this.delegate = delegate;
    }

    public void setDataBufferFactory(DataBufferFactory dataBufferFactory) {
        Assert.notNull((Object)dataBufferFactory, (String)"DataBufferFactory must not be null");
        this.dataBufferFactory = dataBufferFactory;
    }

    public void handleRequest(final HttpServerExchange exchange) throws Exception {
        UndertowServerHttpRequest request = new UndertowServerHttpRequest(exchange, this.dataBufferFactory);
        UndertowServerHttpResponse response = new UndertowServerHttpResponse(exchange, this.dataBufferFactory);
        this.delegate.handle(request, response).subscribe((Subscriber)new Subscriber<Void>(){

            public void onSubscribe(Subscription subscription) {
                subscription.request(Long.MAX_VALUE);
            }

            public void onNext(Void aVoid) {
            }

            public void onError(Throwable ex) {
                logger.debug((Object)"Could not complete request", ex);
                if (!exchange.isResponseStarted() && exchange.getStatusCode() <= 500) {
                    exchange.setStatusCode(500);
                }
                exchange.endExchange();
            }

            public void onComplete() {
                logger.debug((Object)"Successfully completed request");
                exchange.endExchange();
            }
        });
    }
}

