/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client.reactive;

import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.web.client.reactive.ResponseErrorHandler;
import org.springframework.web.client.reactive.WebClientErrorException;
import org.springframework.web.client.reactive.WebServerErrorException;

public class DefaultResponseErrorHandler
implements ResponseErrorHandler {
    @Override
    public void handleError(ClientHttpResponse response, List<HttpMessageReader<?>> messageReaders) {
        HttpStatus responseStatus = response.getStatusCode();
        if (responseStatus.is4xxClientError()) {
            throw new WebClientErrorException(response, messageReaders);
        }
        if (responseStatus.is5xxServerError()) {
            throw new WebServerErrorException(response, messageReaders);
        }
    }
}

