/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.web.server.ResponseStatusException;

public class MethodNotAllowedException
extends ResponseStatusException {
    private String method;
    private Set<String> supportedMethods;

    public MethodNotAllowedException(String method, Collection<String> supportedMethods) {
        super(HttpStatus.METHOD_NOT_ALLOWED, "Request method '" + method + "' not supported");
        Assert.notNull((Object)method, (String)"'method' is required");
        this.method = method;
        this.supportedMethods = Collections.unmodifiableSet(new HashSet<String>(supportedMethods));
    }

    public String getHttpMethod() {
        return this.method;
    }

    public Set<String> getSupportedMethods() {
        return this.supportedMethods;
    }
}

