/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server;

import org.springframework.core.NestedRuntimeException;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public class ResponseStatusException
extends NestedRuntimeException {
    private final HttpStatus status;
    private final String reason;

    public ResponseStatusException(HttpStatus status, String reason) {
        this(status, reason, null);
    }

    public ResponseStatusException(HttpStatus status, String reason, Throwable cause) {
        super("Request failure [status: " + (Object)((Object)status) + ", reason: \"" + reason + "\"]", cause);
        Assert.notNull((Object)((Object)status), (String)"'status' is required");
        Assert.notNull((Object)reason, (String)"'reason' is required");
        this.status = status;
        this.reason = reason;
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    public String getReason() {
        return this.reason;
    }
}

