/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server.handler;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.NestedCheckedException;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebExceptionHandler;
import org.springframework.web.server.WebHandler;
import org.springframework.web.server.handler.WebHandlerDecorator;
import reactor.core.publisher.Mono;

public class ExceptionHandlingWebHandler
extends WebHandlerDecorator {
    private static Log logger = LogFactory.getLog(ExceptionHandlingWebHandler.class);
    private static final String DISCONNECTED_CLIENT_LOG_CATEGORY = ExceptionHandlingWebHandler.class.getName() + ".DisconnectedClient";
    private static final Log disconnectedClientLogger = LogFactory.getLog((String)DISCONNECTED_CLIENT_LOG_CATEGORY);
    private static final Set<String> DISCONNECTED_CLIENT_EXCEPTIONS;
    private final List<WebExceptionHandler> exceptionHandlers;

    public ExceptionHandlingWebHandler(WebHandler delegate, WebExceptionHandler ... exceptionHandlers) {
        super(delegate);
        this.exceptionHandlers = ExceptionHandlingWebHandler.initList(exceptionHandlers);
    }

    private static List<WebExceptionHandler> initList(WebExceptionHandler[] list) {
        return list != null ? Collections.unmodifiableList(Arrays.asList(list)) : Collections.emptyList();
    }

    public List<WebExceptionHandler> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    @Override
    public Mono<Void> handle(ServerWebExchange exchange) {
        Mono mono;
        try {
            mono = this.getDelegate().handle(exchange);
        }
        catch (Throwable ex2) {
            mono = Mono.error((Throwable)ex2);
        }
        for (WebExceptionHandler exceptionHandler : this.exceptionHandlers) {
            mono = mono.otherwise(ex -> exceptionHandler.handle(exchange, (Throwable)ex));
        }
        return mono.otherwise(ex -> this.handleUnresolvedException(exchange, (Throwable)ex));
    }

    private Mono<? extends Void> handleUnresolvedException(ServerWebExchange exchange, Throwable ex) {
        this.logException(ex);
        exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
        return Mono.empty();
    }

    private void logException(Throwable ex) {
        NestedCheckedException nestedException = new NestedCheckedException("", ex){};
        if ("Broken pipe".equalsIgnoreCase(nestedException.getMostSpecificCause().getMessage()) || DISCONNECTED_CLIENT_EXCEPTIONS.contains(ex.getClass().getSimpleName())) {
            if (disconnectedClientLogger.isTraceEnabled()) {
                disconnectedClientLogger.trace((Object)"Looks like the client has gone away", ex);
            } else if (disconnectedClientLogger.isDebugEnabled()) {
                disconnectedClientLogger.debug((Object)("Looks like the client has gone away: " + nestedException.getMessage() + " (For full stack trace, set the '" + DISCONNECTED_CLIENT_LOG_CATEGORY + "' log category to TRACE level)"));
            }
        } else {
            logger.debug((Object)"Could not complete request", ex);
        }
    }

    static {
        HashSet<String> set = new HashSet<String>(3);
        set.add("ClientAbortException");
        set.add("EOFException");
        set.add("EofException");
        DISCONNECTED_CLIENT_EXCEPTIONS = Collections.unmodifiableSet(set);
    }
}

