/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.multipart;

import java.io.IOException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.Channel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.CodecException;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.PooledDataBuffer;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMessage;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.LoggingCodecSupport;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.http.codec.multipart.FormFieldPart;
import org.springframework.http.codec.multipart.Part;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultMultipartMessageReader
extends LoggingCodecSupport
implements HttpMessageReader<Part> {
    private static final Log logger = LogFactory.getLog(DefaultMultipartMessageReader.class);
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte HYPHEN = 45;
    private static final byte[] FIRST_BOUNDARY_PREFIX = new byte[]{45, 45};
    private static final byte[] BOUNDARY_PREFIX = new byte[]{13, 10, 45, 45};
    private static final byte[] HEADER_BODY_SEPARATOR = new byte[]{13, 10, 13, 10};
    private static final String HEADER_SEPARATOR = "\\r\\n";
    private static final DataBufferUtils.Matcher HEADER_MATCHER = DataBufferUtils.matcher((byte[])HEADER_BODY_SEPARATOR);

    @Override
    public List<MediaType> getReadableMediaTypes() {
        return Collections.singletonList(MediaType.MULTIPART_FORM_DATA);
    }

    @Override
    public boolean canRead(ResolvableType elementType, @Nullable MediaType mediaType) {
        return Part.class.equals((Object)elementType.toClass()) && (mediaType == null || MediaType.MULTIPART_FORM_DATA.isCompatibleWith(mediaType));
    }

    @Override
    public Flux<Part> read(ResolvableType elementType, ReactiveHttpInputMessage message, Map<String, Object> hints) {
        byte[] boundary = DefaultMultipartMessageReader.boundary(message);
        if (boundary == null) {
            return Flux.error((Throwable)new CodecException("No multipart boundary found in Content-Type: \"" + message.getHeaders().getContentType() + "\""));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Boundary: " + DefaultMultipartMessageReader.toString(boundary)));
        }
        byte[] boundaryNeedle = DefaultMultipartMessageReader.concat(BOUNDARY_PREFIX, boundary);
        Flux<DataBuffer> body = DefaultMultipartMessageReader.skipUntilFirstBoundary(message.getBody(), boundary);
        return DataBufferUtils.split(body, (byte[])boundaryNeedle).takeWhile(DefaultMultipartMessageReader::notLastBoundary).map(DefaultMultipartMessageReader::toPart).doOnDiscard(PooledDataBuffer.class, DataBufferUtils::release).doOnDiscard(DefaultPart.class, part -> DataBufferUtils.release((DataBuffer)part.body));
    }

    @Nullable
    private static byte[] boundary(HttpMessage message) {
        String boundary;
        MediaType contentType = message.getHeaders().getContentType();
        if (contentType != null && (boundary = contentType.getParameter("boundary")) != null) {
            return boundary.getBytes(StandardCharsets.ISO_8859_1);
        }
        return null;
    }

    private static Flux<DataBuffer> skipUntilFirstBoundary(Flux<DataBuffer> dataBuffers, byte[] boundary) {
        byte[] needle = DefaultMultipartMessageReader.concat(FIRST_BOUNDARY_PREFIX, boundary);
        DataBufferUtils.Matcher matcher = DataBufferUtils.matcher((byte[])needle);
        AtomicBoolean found = new AtomicBoolean();
        return dataBuffers.concatMap(dataBuffer -> {
            if (found.get()) {
                return Mono.just((Object)dataBuffer);
            }
            int endIdx = matcher.match(dataBuffer);
            if (endIdx != -1) {
                found.set(true);
                int length = dataBuffer.writePosition() - 1 - endIdx;
                DataBuffer slice = dataBuffer.retainedSlice(endIdx + 1, length);
                DataBufferUtils.release((DataBuffer)dataBuffer);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Found first boundary at " + endIdx + " in " + DefaultMultipartMessageReader.toString(dataBuffer)));
                }
                return Mono.just((Object)slice);
            }
            DataBufferUtils.release((DataBuffer)dataBuffer);
            return Mono.empty();
        });
    }

    private static boolean notLastBoundary(DataBuffer dataBuffer) {
        int readPosition;
        if (dataBuffer.readableByteCount() >= 2 && dataBuffer.getByte(readPosition = dataBuffer.readPosition()) == 45 && dataBuffer.getByte(readPosition + 1) == 45) {
            DataBufferUtils.release((DataBuffer)dataBuffer);
            return false;
        }
        return true;
    }

    private static Part toPart(DataBuffer dataBuffer) {
        HttpHeaders headers;
        DataBuffer body;
        int endIdx;
        int readPosition = dataBuffer.readPosition();
        if (dataBuffer.readableByteCount() >= 2 && dataBuffer.getByte(readPosition) == 13 && dataBuffer.getByte(readPosition + 1) == 10) {
            dataBuffer.readPosition(readPosition + 2);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Part data: " + DefaultMultipartMessageReader.toString(dataBuffer)));
        }
        if ((endIdx = HEADER_MATCHER.match(dataBuffer)) > 0) {
            readPosition = dataBuffer.readPosition();
            int headersLength = endIdx + 1 - (readPosition + HEADER_BODY_SEPARATOR.length);
            DataBuffer headersBuffer = dataBuffer.retainedSlice(readPosition, headersLength);
            int bodyLength = dataBuffer.writePosition() - (1 + endIdx);
            body = dataBuffer.retainedSlice(endIdx + 1, bodyLength);
            headers = DefaultMultipartMessageReader.toHeaders(headersBuffer);
        } else {
            headers = new HttpHeaders();
            body = DataBufferUtils.retain((DataBuffer)dataBuffer);
        }
        DataBufferUtils.release((DataBuffer)dataBuffer);
        ContentDisposition cd = headers.getContentDisposition();
        MediaType contentType = headers.getContentType();
        if (StringUtils.hasLength((String)cd.getFilename())) {
            return new DefaultFilePart(headers, body);
        }
        if (StringUtils.hasLength((String)cd.getName()) && (contentType == null || MediaType.TEXT_PLAIN.isCompatibleWith(contentType))) {
            return new DefaultFormPart(headers, body);
        }
        return new DefaultPart(headers, body);
    }

    private static HttpHeaders toHeaders(DataBuffer dataBuffer) {
        byte[] bytes = new byte[dataBuffer.readableByteCount()];
        dataBuffer.read(bytes);
        DataBufferUtils.release((DataBuffer)dataBuffer);
        String string = new String(bytes, StandardCharsets.US_ASCII);
        String[] lines = string.split(HEADER_SEPARATOR);
        HttpHeaders result = new HttpHeaders();
        for (String line : lines) {
            String[] tokens;
            int idx = line.indexOf(58);
            if (idx == -1) continue;
            String name = line.substring(0, idx);
            String value = line.substring(idx + 1);
            while (value.startsWith(" ")) {
                value = value.substring(1);
            }
            for (String token : tokens = StringUtils.tokenizeToStringArray((String)value, (String)",")) {
                result.add(name, token);
            }
        }
        return result;
    }

    private static String toString(DataBuffer dataBuffer) {
        byte[] bytes = new byte[dataBuffer.readableByteCount()];
        int j = 0;
        for (int i = dataBuffer.readPosition(); i < dataBuffer.writePosition(); ++i) {
            bytes[j++] = dataBuffer.getByte(i);
        }
        return DefaultMultipartMessageReader.toString(bytes);
    }

    private static String toString(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (byte b : bytes) {
            if (b == 13) {
                builder.append("\u240d");
                continue;
            }
            if (b == 10) {
                builder.append("\u2424");
                continue;
            }
            if (b < 20 || b > 126) continue;
            builder.append((char)b);
        }
        return builder.toString();
    }

    @Override
    public Mono<Part> readMono(ResolvableType elementType, ReactiveHttpInputMessage message, Map<String, Object> hints) {
        return Mono.error((Throwable)new UnsupportedOperationException("Cannot read multipart request body into single Part"));
    }

    private static byte[] concat(byte[] ... byteArrays) {
        int length = 0;
        for (byte[] byteArray : byteArrays) {
            length += byteArray.length;
        }
        byte[] result = new byte[length];
        length = 0;
        for (byte[] byteArray : byteArrays) {
            System.arraycopy(byteArray, 0, result, length, byteArray.length);
            length += byteArray.length;
        }
        return result;
    }

    private static class DefaultFilePart
    extends DefaultPart
    implements FilePart {
        private static final OpenOption[] FILE_CHANNEL_OPTIONS = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};

        public DefaultFilePart(HttpHeaders headers, DataBuffer body) {
            super(headers, body);
        }

        @Override
        public String filename() {
            String filename = this.headers().getContentDisposition().getFilename();
            Assert.state((filename != null ? 1 : 0) != 0, (String)"No filename available");
            return filename;
        }

        @Override
        public Mono<Void> transferTo(Path dest) {
            return Mono.using(() -> AsynchronousFileChannel.open(dest, FILE_CHANNEL_OPTIONS), this::writeBody, this::close);
        }

        private Mono<Void> writeBody(AsynchronousFileChannel channel) {
            return DataBufferUtils.write(this.content(), (AsynchronousFileChannel)channel).map(DataBufferUtils::release).then();
        }

        private void close(Channel channel) {
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class DefaultFormPart
    extends DefaultPart
    implements FormFieldPart {
        private String value;

        public DefaultFormPart(HttpHeaders headers, DataBuffer body) {
            super(headers, body);
            this.value = DefaultFormPart.toString(body, DefaultFormPart.contentTypeCharset(headers));
        }

        private static String toString(DataBuffer dataBuffer, Charset charset) {
            byte[] bytes = new byte[dataBuffer.readableByteCount()];
            dataBuffer.read(bytes);
            DataBufferUtils.release((DataBuffer)dataBuffer);
            return new String(bytes, charset).trim();
        }

        private static Charset contentTypeCharset(HttpHeaders headers) {
            Charset charset;
            MediaType contentType = headers.getContentType();
            if (contentType != null && (charset = contentType.getCharset()) != null) {
                return charset;
            }
            return StandardCharsets.ISO_8859_1;
        }

        @Override
        public String value() {
            return this.value;
        }
    }

    private static class DefaultPart
    implements Part {
        private final HttpHeaders headers;
        protected final DataBuffer body;

        public DefaultPart(HttpHeaders headers, DataBuffer body) {
            this.headers = headers;
            this.body = body;
        }

        @Override
        public String name() {
            String name = this.headers().getContentDisposition().getName();
            Assert.state((name != null ? 1 : 0) != 0, (String)"No name available");
            return name;
        }

        @Override
        public HttpHeaders headers() {
            return this.headers;
        }

        @Override
        public Flux<DataBuffer> content() {
            return Flux.just((Object)this.body);
        }
    }
}

