/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.xml;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchema;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.xml.namespace.QName;
import javax.xml.stream.events.XMLEvent;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SynchronousSink;

abstract class Jaxb2Helper {
    private static final String JAXB_DEFAULT_ANNOTATION_VALUE = "##default";

    Jaxb2Helper() {
    }

    public static Set<QName> toQNames(Class<?> clazz) {
        HashSet<QName> result = new HashSet<QName>(1);
        Jaxb2Helper.findQNames(clazz, result, new HashSet());
        return result;
    }

    private static void findQNames(Class<?> clazz, Set<QName> qNames, Set<Class<?>> completedClasses) {
        XmlRootElement annotation;
        if (completedClasses.contains(clazz)) {
            return;
        }
        if (clazz.isAnnotationPresent(XmlRootElement.class)) {
            annotation = clazz.getAnnotation(XmlRootElement.class);
            qNames.add(new QName(Jaxb2Helper.namespace(annotation.namespace(), clazz), Jaxb2Helper.localPart(annotation.name(), clazz)));
        } else if (clazz.isAnnotationPresent(XmlType.class)) {
            annotation = clazz.getAnnotation(XmlType.class);
            qNames.add(new QName(Jaxb2Helper.namespace(annotation.namespace(), clazz), Jaxb2Helper.localPart(annotation.name(), clazz)));
        } else {
            throw new IllegalArgumentException("Output class [" + clazz.getName() + "] is neither annotated with @XmlRootElement nor @XmlType");
        }
        completedClasses.add(clazz);
        if (clazz.isAnnotationPresent(XmlSeeAlso.class)) {
            annotation = clazz.getAnnotation(XmlSeeAlso.class);
            for (Class seeAlso : annotation.value()) {
                Jaxb2Helper.findQNames(seeAlso, qNames, completedClasses);
            }
        }
    }

    private static String localPart(String value, Class<?> outputClass) {
        if (JAXB_DEFAULT_ANNOTATION_VALUE.equals(value)) {
            return ClassUtils.getShortNameAsProperty(outputClass);
        }
        return value;
    }

    private static String namespace(String value, Class<?> outputClass) {
        if (JAXB_DEFAULT_ANNOTATION_VALUE.equals(value)) {
            Package outputClassPackage = outputClass.getPackage();
            if (outputClassPackage != null && outputClassPackage.isAnnotationPresent(XmlSchema.class)) {
                XmlSchema annotation = outputClassPackage.getAnnotation(XmlSchema.class);
                return annotation.namespace();
            }
            return "";
        }
        return value;
    }

    public static Flux<List<XMLEvent>> split(Flux<XMLEvent> xmlEventFlux, Set<QName> names) {
        return xmlEventFlux.handle((BiConsumer)new SplitHandler(names));
    }

    private static class SplitHandler
    implements BiConsumer<XMLEvent, SynchronousSink<List<XMLEvent>>> {
        private final Set<QName> names;
        private @Nullable List<XMLEvent> events;
        private int elementDepth = 0;
        private int barrier = Integer.MAX_VALUE;

        public SplitHandler(Set<QName> names) {
            this.names = names;
        }

        @Override
        public void accept(XMLEvent event, SynchronousSink<List<XMLEvent>> sink) {
            if (event.isStartElement()) {
                QName startElementName;
                if (this.barrier == Integer.MAX_VALUE && this.names.contains(startElementName = event.asStartElement().getName())) {
                    this.events = new ArrayList<XMLEvent>();
                    this.barrier = this.elementDepth;
                }
                ++this.elementDepth;
            }
            if (this.elementDepth > this.barrier) {
                Assert.state((this.events != null ? 1 : 0) != 0, (String)"No XMLEvent List");
                this.events.add(event);
            }
            if (event.isEndElement()) {
                --this.elementDepth;
                if (this.elementDepth == this.barrier) {
                    this.barrier = Integer.MAX_VALUE;
                    Assert.state((this.events != null ? 1 : 0) != 0, (String)"No XMLEvent List");
                    sink.next(this.events);
                }
            }
        }
    }
}

