/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.JettyClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.DefaultWebClient;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.ExchangeFunctions;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilderFactory;

final class DefaultWebClientBuilder
implements WebClient.Builder {
    private static final boolean reactorClientPresent;
    private static final boolean jettyClientPresent;
    @Nullable
    private String baseUrl;
    @Nullable
    private Map<String, ?> defaultUriVariables;
    @Nullable
    private UriBuilderFactory uriBuilderFactory;
    @Nullable
    private HttpHeaders defaultHeaders;
    @Nullable
    private MultiValueMap<String, String> defaultCookies;
    @Nullable
    private Consumer<WebClient.RequestHeadersSpec<?>> defaultRequest;
    @Nullable
    private List<ExchangeFilterFunction> filters;
    @Nullable
    private ClientHttpConnector connector;
    @Nullable
    private ExchangeStrategies strategies;
    @Nullable
    private List<Consumer<ExchangeStrategies.Builder>> strategiesConfigurers;
    @Nullable
    private ExchangeFunction exchangeFunction;

    public DefaultWebClientBuilder() {
    }

    public DefaultWebClientBuilder(DefaultWebClientBuilder other) {
        Assert.notNull((Object)other, (String)"DefaultWebClientBuilder must not be null");
        this.baseUrl = other.baseUrl;
        this.defaultUriVariables = other.defaultUriVariables != null ? new LinkedHashMap(other.defaultUriVariables) : null;
        this.uriBuilderFactory = other.uriBuilderFactory;
        if (other.defaultHeaders != null) {
            this.defaultHeaders = new HttpHeaders();
            this.defaultHeaders.putAll((Map)other.defaultHeaders);
        } else {
            this.defaultHeaders = null;
        }
        this.defaultCookies = other.defaultCookies != null ? new LinkedMultiValueMap(other.defaultCookies) : null;
        this.defaultRequest = other.defaultRequest;
        this.filters = other.filters != null ? new ArrayList<ExchangeFilterFunction>(other.filters) : null;
        this.connector = other.connector;
        this.strategies = other.strategies;
        this.strategiesConfigurers = other.strategiesConfigurers != null ? new ArrayList<Consumer<ExchangeStrategies.Builder>>(other.strategiesConfigurers) : null;
        this.exchangeFunction = other.exchangeFunction;
    }

    @Override
    public WebClient.Builder baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    @Override
    public WebClient.Builder defaultUriVariables(Map<String, ?> defaultUriVariables) {
        this.defaultUriVariables = defaultUriVariables;
        return this;
    }

    @Override
    public WebClient.Builder uriBuilderFactory(UriBuilderFactory uriBuilderFactory) {
        this.uriBuilderFactory = uriBuilderFactory;
        return this;
    }

    @Override
    public WebClient.Builder defaultHeader(String header, String ... values) {
        this.initHeaders().put(header, Arrays.asList(values));
        return this;
    }

    @Override
    public WebClient.Builder defaultHeaders(Consumer<HttpHeaders> headersConsumer) {
        headersConsumer.accept(this.initHeaders());
        return this;
    }

    private HttpHeaders initHeaders() {
        if (this.defaultHeaders == null) {
            this.defaultHeaders = new HttpHeaders();
        }
        return this.defaultHeaders;
    }

    @Override
    public WebClient.Builder defaultCookie(String cookie, String ... values) {
        this.initCookies().addAll((Object)cookie, Arrays.asList(values));
        return this;
    }

    @Override
    public WebClient.Builder defaultCookies(Consumer<MultiValueMap<String, String>> cookiesConsumer) {
        cookiesConsumer.accept(this.initCookies());
        return this;
    }

    private MultiValueMap<String, String> initCookies() {
        if (this.defaultCookies == null) {
            this.defaultCookies = new LinkedMultiValueMap(4);
        }
        return this.defaultCookies;
    }

    @Override
    public WebClient.Builder defaultRequest(Consumer<WebClient.RequestHeadersSpec<?>> defaultRequest) {
        this.defaultRequest = this.defaultRequest != null ? this.defaultRequest.andThen(defaultRequest) : defaultRequest;
        return this;
    }

    @Override
    public WebClient.Builder filter(ExchangeFilterFunction filter) {
        Assert.notNull((Object)filter, (String)"ExchangeFilterFunction must not be null");
        this.initFilters().add(filter);
        return this;
    }

    @Override
    public WebClient.Builder filters(Consumer<List<ExchangeFilterFunction>> filtersConsumer) {
        filtersConsumer.accept(this.initFilters());
        return this;
    }

    private List<ExchangeFilterFunction> initFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList<ExchangeFilterFunction>();
        }
        return this.filters;
    }

    @Override
    public WebClient.Builder clientConnector(ClientHttpConnector connector) {
        this.connector = connector;
        return this;
    }

    @Override
    public WebClient.Builder codecs(Consumer<ClientCodecConfigurer> configurer) {
        if (this.strategiesConfigurers == null) {
            this.strategiesConfigurers = new ArrayList<Consumer<ExchangeStrategies.Builder>>(4);
        }
        this.strategiesConfigurers.add(builder -> builder.codecs(configurer));
        return this;
    }

    @Override
    public WebClient.Builder exchangeStrategies(ExchangeStrategies strategies) {
        this.strategies = strategies;
        return this;
    }

    @Override
    @Deprecated
    public WebClient.Builder exchangeStrategies(Consumer<ExchangeStrategies.Builder> configurer) {
        if (this.strategiesConfigurers == null) {
            this.strategiesConfigurers = new ArrayList<Consumer<ExchangeStrategies.Builder>>(4);
        }
        this.strategiesConfigurers.add(configurer);
        return this;
    }

    @Override
    public WebClient.Builder exchangeFunction(ExchangeFunction exchangeFunction) {
        this.exchangeFunction = exchangeFunction;
        return this;
    }

    @Override
    public WebClient.Builder apply(Consumer<WebClient.Builder> builderConsumer) {
        builderConsumer.accept(this);
        return this;
    }

    @Override
    public WebClient.Builder clone() {
        return new DefaultWebClientBuilder(this);
    }

    @Override
    public WebClient build() {
        ExchangeFunction exchange = this.exchangeFunction == null ? ExchangeFunctions.create(this.getOrInitConnector(), this.initExchangeStrategies()) : this.exchangeFunction;
        ExchangeFunction filteredExchange = this.filters != null ? this.filters.stream().reduce(ExchangeFilterFunction::andThen).map(filter -> filter.apply(exchange)).orElse(exchange) : exchange;
        return new DefaultWebClient(filteredExchange, this.initUriBuilderFactory(), this.defaultHeaders != null ? HttpHeaders.readOnlyHttpHeaders((HttpHeaders)this.defaultHeaders) : null, (MultiValueMap<String, String>)(this.defaultCookies != null ? CollectionUtils.unmodifiableMultiValueMap(this.defaultCookies) : null), this.defaultRequest, new DefaultWebClientBuilder(this));
    }

    private ClientHttpConnector getOrInitConnector() {
        if (this.connector != null) {
            return this.connector;
        }
        if (reactorClientPresent) {
            return new ReactorClientHttpConnector();
        }
        if (jettyClientPresent) {
            return new JettyClientHttpConnector();
        }
        throw new IllegalStateException("No suitable default ClientHttpConnector found");
    }

    private ExchangeStrategies initExchangeStrategies() {
        if (CollectionUtils.isEmpty(this.strategiesConfigurers)) {
            return this.strategies != null ? this.strategies : ExchangeStrategies.withDefaults();
        }
        ExchangeStrategies.Builder builder = this.strategies != null ? this.strategies.mutate() : ExchangeStrategies.builder();
        this.strategiesConfigurers.forEach(configurer -> configurer.accept(builder));
        return builder.build();
    }

    private UriBuilderFactory initUriBuilderFactory() {
        if (this.uriBuilderFactory != null) {
            return this.uriBuilderFactory;
        }
        DefaultUriBuilderFactory factory = this.baseUrl != null ? new DefaultUriBuilderFactory(this.baseUrl) : new DefaultUriBuilderFactory();
        factory.setDefaultUriVariables(this.defaultUriVariables);
        return factory;
    }

    static {
        ClassLoader loader = DefaultWebClientBuilder.class.getClassLoader();
        reactorClientPresent = ClassUtils.isPresent((String)"reactor.netty.http.client.HttpClient", (ClassLoader)loader);
        jettyClientPresent = ClassUtils.isPresent((String)"org.eclipse.jetty.client.HttpClient", (ClassLoader)loader);
    }
}

