/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.tiles2;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tiles.TilesException;
import org.apache.tiles.preparer.NoSuchPreparerException;
import org.apache.tiles.preparer.PreparerException;
import org.apache.tiles.preparer.ViewPreparer;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.view.tiles2.AbstractSpringPreparerFactory;

public class SimpleSpringPreparerFactory
extends AbstractSpringPreparerFactory {
    private final Map<String, ViewPreparer> sharedPreparers = new ConcurrentHashMap<String, ViewPreparer>(16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ViewPreparer getPreparer(String name, WebApplicationContext context) throws TilesException {
        ViewPreparer preparer = this.sharedPreparers.get(name);
        if (preparer == null) {
            Map<String, ViewPreparer> map = this.sharedPreparers;
            synchronized (map) {
                preparer = this.sharedPreparers.get(name);
                if (preparer == null) {
                    try {
                        Class<?> beanClass = context.getClassLoader().loadClass(name);
                        if (!ViewPreparer.class.isAssignableFrom(beanClass)) {
                            throw new PreparerException("Invalid preparer class [" + name + "]: does not implement ViewPreparer interface");
                        }
                        preparer = (ViewPreparer)context.getAutowireCapableBeanFactory().createBean(beanClass);
                        this.sharedPreparers.put(name, preparer);
                    }
                    catch (ClassNotFoundException ex) {
                        throw new NoSuchPreparerException("Preparer class [" + name + "] not found", (Exception)ex);
                    }
                }
            }
        }
        return preparer;
    }
}

