/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket;

import java.nio.ByteBuffer;
import org.springframework.web.socket.WebSocketMessage;

public final class BinaryMessage
extends WebSocketMessage<ByteBuffer> {
    private byte[] bytes;

    public BinaryMessage(ByteBuffer payload) {
        this(payload, true);
    }

    public BinaryMessage(ByteBuffer payload, boolean isLast) {
        super(payload, isLast);
        this.bytes = null;
    }

    public BinaryMessage(byte[] payload) {
        this(payload, 0, payload == null ? 0 : payload.length, true);
    }

    public BinaryMessage(byte[] payload, boolean isLast) {
        this(payload, 0, payload == null ? 0 : payload.length, isLast);
    }

    public BinaryMessage(byte[] payload, int offset, int len, boolean isLast) {
        super(payload != null ? ByteBuffer.wrap(payload, offset, len) : null, isLast);
        if (offset == 0 && len == payload.length) {
            this.bytes = payload;
        }
    }

    public byte[] getByteArray() {
        if (this.bytes == null && this.getPayload() != null) {
            this.bytes = this.getRemainingBytes((ByteBuffer)this.getPayload());
        }
        return this.bytes;
    }

    private byte[] getRemainingBytes(ByteBuffer payload) {
        byte[] result = new byte[((ByteBuffer)this.getPayload()).remaining()];
        ((ByteBuffer)this.getPayload()).get(result);
        return result;
    }

    @Override
    protected int getPayloadSize() {
        return this.getPayload() != null ? ((ByteBuffer)this.getPayload()).remaining() : 0;
    }
}

