/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket;

import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class WebSocketMessage<T> {
    private final T payload;
    private final boolean last;

    WebSocketMessage(T payload, boolean isLast) {
        Assert.notNull(payload, (String)"Payload must not be null");
        this.payload = payload;
        this.last = isLast;
    }

    public T getPayload() {
        return this.payload;
    }

    public boolean isLast() {
        return this.last;
    }

    public int hashCode() {
        return WebSocketMessage.class.hashCode() * 13 + ObjectUtils.nullSafeHashCode(this.payload);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WebSocketMessage)) {
            return false;
        }
        WebSocketMessage otherMessage = (WebSocketMessage)other;
        return ObjectUtils.nullSafeEquals(this.payload, otherMessage.payload);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [payload length=" + this.getPayloadSize() + ", last=" + this.isLast() + "]";
    }

    protected abstract int getPayloadSize();
}

