/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.adapter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.springframework.util.Assert;
import org.springframework.web.socket.BinaryMessage;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.adapter.JettyWebSocketSessionAdapter;
import org.springframework.web.socket.support.ExceptionWebSocketHandlerDecorator;

public class JettyWebSocketListenerAdapter
implements WebSocketListener {
    private static final Log logger = LogFactory.getLog(JettyWebSocketListenerAdapter.class);
    private final WebSocketHandler webSocketHandler;
    private JettyWebSocketSessionAdapter wsSession;

    public JettyWebSocketListenerAdapter(WebSocketHandler webSocketHandler, JettyWebSocketSessionAdapter wsSession) {
        Assert.notNull((Object)webSocketHandler, (String)"webSocketHandler is required");
        Assert.notNull((Object)wsSession, (String)"wsSession is required");
        this.webSocketHandler = webSocketHandler;
        this.wsSession = wsSession;
    }

    public void onWebSocketConnect(Session session) {
        this.wsSession.initSession(session);
        try {
            this.webSocketHandler.afterConnectionEstablished(this.wsSession);
        }
        catch (Throwable t) {
            ExceptionWebSocketHandlerDecorator.tryCloseWithError(this.wsSession, t, logger);
        }
    }

    public void onWebSocketText(String payload) {
        TextMessage message = new TextMessage(payload);
        try {
            this.webSocketHandler.handleMessage(this.wsSession, message);
        }
        catch (Throwable t) {
            ExceptionWebSocketHandlerDecorator.tryCloseWithError(this.wsSession, t, logger);
        }
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        BinaryMessage message = new BinaryMessage(payload, offset, len, true);
        try {
            this.webSocketHandler.handleMessage(this.wsSession, message);
        }
        catch (Throwable t) {
            ExceptionWebSocketHandlerDecorator.tryCloseWithError(this.wsSession, t, logger);
        }
    }

    public void onWebSocketClose(int statusCode, String reason) {
        CloseStatus closeStatus = new CloseStatus(statusCode, reason);
        try {
            this.webSocketHandler.afterConnectionClosed(this.wsSession, closeStatus);
        }
        catch (Throwable t) {
            logger.error((Object)("Unhandled error for " + this.wsSession), t);
        }
    }

    public void onWebSocketError(Throwable cause) {
        try {
            this.webSocketHandler.handleTransportError(this.wsSession, cause);
        }
        catch (Throwable t) {
            ExceptionWebSocketHandlerDecorator.tryCloseWithError(this.wsSession, t, logger);
        }
    }
}

