/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.adapter;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.Principal;
import javax.websocket.CloseReason;
import javax.websocket.Session;
import org.springframework.util.Assert;
import org.springframework.web.socket.BinaryMessage;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.adapter.AbstractWebSocketSesssionAdapter;

public class StandardWebSocketSessionAdapter
extends AbstractWebSocketSesssionAdapter<Session> {
    private Session session;
    private URI uri;
    private String remoteHostName;
    private String remoteAddress;

    @Override
    public void initSession(Session session) {
        Assert.notNull((Object)session, (String)"session is required");
        this.session = session;
    }

    @Override
    public String getId() {
        return this.session.getId();
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public void setUri(URI uri) {
        this.uri = uri;
    }

    @Override
    public boolean isSecure() {
        return this.session.isSecure();
    }

    @Override
    public Principal getPrincipal() {
        return this.session.getUserPrincipal();
    }

    @Override
    public void setPrincipal(Principal principal) {
    }

    @Override
    public String getRemoteHostName() {
        return this.remoteHostName;
    }

    @Override
    public void setRemoteHostName(String name) {
        this.remoteHostName = name;
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public void setRemoteAddress(String address) {
        this.remoteAddress = address;
    }

    @Override
    public boolean isOpen() {
        return this.session.isOpen();
    }

    @Override
    protected void sendTextMessage(TextMessage message) throws IOException {
        this.session.getBasicRemote().sendText((String)message.getPayload(), message.isLast());
    }

    @Override
    protected void sendBinaryMessage(BinaryMessage message) throws IOException {
        this.session.getBasicRemote().sendBinary((ByteBuffer)message.getPayload(), message.isLast());
    }

    @Override
    protected void closeInternal(CloseStatus status) throws IOException {
        this.session.close(new CloseReason(CloseReason.CloseCodes.getCloseCode((int)status.getCode()), status.getReason()));
    }
}

