/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.client;

import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class ConnectionManagerSupport
implements SmartLifecycle {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final URI uri;
    private boolean autoStartup = false;
    private boolean isRunning = false;
    private int phase = Integer.MAX_VALUE;
    private TaskExecutor taskExecutor = new SimpleAsyncTaskExecutor("EndpointConnectionManager-");
    private final Object lifecycleMonitor = new Object();

    public ConnectionManagerSupport(String uriTemplate, Object ... uriVariables) {
        this.uri = UriComponentsBuilder.fromUriString((String)uriTemplate).buildAndExpand(uriVariables).encode().toUri();
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    protected URI getUri() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.isRunning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.isRunning()) {
                this.startInternal();
            }
        }
    }

    protected void startInternal() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Starting " + this.getClass().getSimpleName()));
        }
        this.isRunning = true;
        this.taskExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ConnectionManagerSupport.this.lifecycleMonitor;
                synchronized (object) {
                    try {
                        ConnectionManagerSupport.this.logger.info((Object)("Connecting to WebSocket at " + ConnectionManagerSupport.this.uri));
                        ConnectionManagerSupport.this.openConnection();
                        ConnectionManagerSupport.this.logger.info((Object)"Successfully connected");
                    }
                    catch (Throwable ex) {
                        ConnectionManagerSupport.this.logger.error((Object)"Failed to connect", ex);
                    }
                }
            }
        });
    }

    protected abstract void openConnection() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Stopping " + this.getClass().getSimpleName()));
                }
                try {
                    this.stopInternal();
                }
                catch (Throwable e) {
                    this.logger.error((Object)"Failed to stop WebSocket connection", e);
                }
                finally {
                    this.isRunning = false;
                }
            }
        }
    }

    protected void stopInternal() throws Exception {
        if (this.isConnected()) {
            this.closeConnection();
        }
    }

    protected abstract boolean isConnected();

    protected abstract void closeConnection() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(Runnable callback) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.stop();
            callback.run();
        }
    }
}

