/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.client;

import java.util.ArrayList;
import java.util.List;
import org.springframework.context.SmartLifecycle;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.client.ConnectionManagerSupport;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.support.LoggingWebSocketHandlerDecorator;

public class WebSocketConnectionManager
extends ConnectionManagerSupport {
    private final WebSocketClient client;
    private final WebSocketHandler webSocketHandler;
    private WebSocketSession webSocketSession;
    private final List<String> subProtocols = new ArrayList<String>();
    private final boolean syncClientLifecycle;

    public WebSocketConnectionManager(WebSocketClient client, WebSocketHandler webSocketHandler, String uriTemplate, Object ... uriVariables) {
        super(uriTemplate, uriVariables);
        this.client = client;
        this.webSocketHandler = this.decorateWebSocketHandler(webSocketHandler);
        this.syncClientLifecycle = client instanceof SmartLifecycle && !((SmartLifecycle)client).isRunning();
    }

    protected WebSocketHandler decorateWebSocketHandler(WebSocketHandler handler) {
        return new LoggingWebSocketHandlerDecorator(handler);
    }

    public void setSubProtocols(List<String> subProtocols) {
        this.subProtocols.clear();
        if (!CollectionUtils.isEmpty(subProtocols)) {
            this.subProtocols.addAll(subProtocols);
        }
    }

    public List<String> getSubProtocols() {
        return this.subProtocols;
    }

    @Override
    public void startInternal() {
        if (this.syncClientLifecycle) {
            ((SmartLifecycle)this.client).start();
        }
        super.startInternal();
    }

    @Override
    public void stopInternal() throws Exception {
        if (this.syncClientLifecycle) {
            ((SmartLifecycle)this.client).stop();
        }
        super.stopInternal();
    }

    @Override
    protected void openConnection() throws Exception {
        HttpHeaders headers = new HttpHeaders();
        headers.setSecWebSocketProtocol(this.subProtocols);
        this.webSocketSession = this.client.doHandshake(this.webSocketHandler, headers, this.getUri());
    }

    @Override
    protected void closeConnection() throws Exception {
        this.webSocketSession.close();
    }

    @Override
    protected boolean isConnected() {
        return this.webSocketSession != null && this.webSocketSession.isOpen();
    }
}

