/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.endpoint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.websocket.Decoder;
import javax.websocket.Encoder;
import javax.websocket.Endpoint;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.util.Assert;
import org.springframework.web.socket.support.BeanCreatingHandlerProvider;

public class ServerEndpointRegistration
implements ServerEndpointConfig,
BeanFactoryAware {
    private final String path;
    private final BeanCreatingHandlerProvider<Endpoint> endpointProvider;
    private final Endpoint endpoint;
    private List<Class<? extends Encoder>> encoders = new ArrayList<Class<? extends Encoder>>();
    private List<Class<? extends Decoder>> decoders = new ArrayList<Class<? extends Decoder>>();
    private List<String> subprotocols = new ArrayList<String>();
    private List<Extension> extensions = new ArrayList<Extension>();
    private final Map<String, Object> userProperties = new HashMap<String, Object>();
    private ServerEndpointConfig.Configurator configurator = new EndpointRegistrationConfigurator();

    public ServerEndpointRegistration(String path, Class<? extends Endpoint> endpointClass) {
        Assert.hasText((String)path, (String)"path must not be empty");
        Assert.notNull(endpointClass, (String)"endpointClass is required");
        this.path = path;
        this.endpointProvider = new BeanCreatingHandlerProvider<Endpoint>(endpointClass);
        this.endpoint = null;
    }

    public ServerEndpointRegistration(String path, Endpoint endpoint) {
        Assert.hasText((String)path, (String)"path must not be empty");
        Assert.notNull((Object)endpoint, (String)"endpoint is required");
        this.path = path;
        this.endpointProvider = null;
        this.endpoint = endpoint;
    }

    public String getPath() {
        return this.path;
    }

    public Class<? extends Endpoint> getEndpointClass() {
        return this.endpoint != null ? this.endpoint.getClass() : this.endpointProvider.getHandlerType();
    }

    public Endpoint getEndpoint() {
        return this.endpoint != null ? this.endpoint : this.endpointProvider.getHandler();
    }

    public void setSubprotocols(List<String> subprotocols) {
        this.subprotocols = subprotocols;
    }

    public List<String> getSubprotocols() {
        return this.subprotocols;
    }

    public void setExtensions(List<Extension> extensions) {
        this.extensions = extensions;
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }

    public void setUserProperties(Map<String, Object> userProperties) {
        this.userProperties.clear();
        this.userProperties.putAll(userProperties);
    }

    public Map<String, Object> getUserProperties() {
        return this.userProperties;
    }

    public void setEncoders(List<Class<? extends Encoder>> encoders) {
        this.encoders = encoders;
    }

    public List<Class<? extends Encoder>> getEncoders() {
        return this.encoders;
    }

    public void setDecoders(List<Class<? extends Decoder>> decoders) {
        this.decoders = decoders;
    }

    public List<Class<? extends Decoder>> getDecoders() {
        return this.decoders;
    }

    public ServerEndpointConfig.Configurator getConfigurator() {
        return this.configurator;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.endpointProvider != null) {
            this.endpointProvider.setBeanFactory(beanFactory);
        }
    }

    protected void modifyHandshake(HandshakeRequest request, HandshakeResponse response) {
        this.configurator.modifyHandshake((ServerEndpointConfig)this, request, response);
    }

    protected boolean checkOrigin(String originHeaderValue) {
        return this.configurator.checkOrigin(originHeaderValue);
    }

    protected String getNegotiatedSubprotocol(List<String> supported, List<String> requested) {
        return this.configurator.getNegotiatedSubprotocol(supported, requested);
    }

    protected List<Extension> getNegotiatedExtensions(List<Extension> installed, List<Extension> requested) {
        return this.configurator.getNegotiatedExtensions(installed, requested);
    }

    private class EndpointRegistrationConfigurator
    extends ServerEndpointConfig.Configurator {
        private EndpointRegistrationConfigurator() {
        }

        public <T> T getEndpointInstance(Class<T> clazz) throws InstantiationException {
            return (T)ServerEndpointRegistration.this.getEndpoint();
        }

        public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
            super.modifyHandshake(sec, request, response);
        }

        public boolean checkOrigin(String originHeaderValue) {
            return super.checkOrigin(originHeaderValue);
        }

        public String getNegotiatedSubprotocol(List<String> supported, List<String> requested) {
            return super.getNegotiatedSubprotocol(supported, requested);
        }

        public List<Extension> getNegotiatedExtensions(List<Extension> installed, List<Extension> requested) {
            return super.getNegotiatedExtensions(installed, requested);
        }
    }
}

