/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.endpoint;

import java.util.Map;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

public class SpringConfigurator
extends ServerEndpointConfig.Configurator {
    private static Log logger = LogFactory.getLog(SpringConfigurator.class);

    public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
        WebApplicationContext wac = ContextLoader.getCurrentWebApplicationContext();
        if (wac == null) {
            String message = "Failed to find the root WebApplicationContext. Was ContextLoaderListener not used?";
            logger.error((Object)message);
            throw new IllegalStateException(message);
        }
        Map beans = wac.getBeansOfType(endpointClass);
        if (beans.isEmpty()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Creating new @ServerEndpoint instance of type " + endpointClass));
            }
            return (T)wac.getAutowireCapableBeanFactory().createBean(endpointClass);
        }
        if (beans.size() == 1) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Using @ServerEndpoint singleton " + (String)beans.keySet().iterator().next()));
            }
            return (T)beans.values().iterator().next();
        }
        String message = "Found more than one matching @ServerEndpoint beans of type " + endpointClass;
        logger.error((Object)message);
        throw new IllegalStateException(message);
    }
}

