/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.support;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.DefaultHandshakeHandler;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.support.ExceptionWebSocketHandlerDecorator;
import org.springframework.web.socket.support.LoggingWebSocketHandlerDecorator;

public class WebSocketHttpRequestHandler
implements HttpRequestHandler {
    private final HandshakeHandler handshakeHandler;
    private final WebSocketHandler webSocketHandler;

    public WebSocketHttpRequestHandler(WebSocketHandler webSocketHandler) {
        this(webSocketHandler, new DefaultHandshakeHandler());
    }

    public WebSocketHttpRequestHandler(WebSocketHandler webSocketHandler, HandshakeHandler handshakeHandler) {
        Assert.notNull((Object)webSocketHandler, (String)"webSocketHandler is required");
        Assert.notNull((Object)handshakeHandler, (String)"handshakeHandler is required");
        this.webSocketHandler = this.decorateWebSocketHandler(webSocketHandler);
        this.handshakeHandler = new DefaultHandshakeHandler();
    }

    protected WebSocketHandler decorateWebSocketHandler(WebSocketHandler handler) {
        handler = new ExceptionWebSocketHandlerDecorator(handler);
        return new LoggingWebSocketHandlerDecorator(handler);
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletServerHttpRequest httpRequest = new ServletServerHttpRequest(request);
        ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
        this.handshakeHandler.doHandshake((ServerHttpRequest)httpRequest, (ServerHttpResponse)httpResponse, this.webSocketHandler);
        httpResponse.flush();
    }
}

