/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.sockjs.SockJsConfiguration;
import org.springframework.web.socket.sockjs.SockJsService;
import org.springframework.web.socket.sockjs.TransportErrorException;
import org.springframework.web.socket.sockjs.TransportType;

public abstract class AbstractSockJsService
implements SockJsService,
SockJsConfiguration {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final int ONE_YEAR = 31536000;
    private String name = "SockJSService@" + ObjectUtils.getIdentityHexString((Object)this);
    private String clientLibraryUrl = "https://d1fxtkz8shb9d2.cloudfront.net/sockjs-0.3.4.min.js";
    private int streamBytesLimit = 131072;
    private boolean jsessionIdCookieRequired = true;
    private long heartbeatTime = 25000L;
    private long disconnectDelay = 5000L;
    private boolean webSocketsEnabled = true;
    private final TaskScheduler taskScheduler;
    private final List<String> validSockJsPrefixes = new ArrayList<String>();
    private final Set<String> knownSockJsPrefixes = new CopyOnWriteArraySet<String>();
    private static final Random random = new Random();
    private final SockJsRequestHandler infoHandler = new SockJsRequestHandler(){
        private static final String INFO_CONTENT = "{\"entropy\":%s,\"origins\":[\"*:*\"],\"cookie_needed\":%s,\"websocket\":%s}";

        @Override
        public void handle(ServerHttpRequest request, ServerHttpResponse response) throws IOException {
            if (HttpMethod.GET.equals((Object)request.getMethod())) {
                response.getHeaders().setContentType(new MediaType("application", "json", Charset.forName("UTF-8")));
                AbstractSockJsService.this.addCorsHeaders(request, response, new HttpMethod[0]);
                AbstractSockJsService.this.addNoCacheHeaders(response);
                String content = String.format(INFO_CONTENT, random.nextInt(), AbstractSockJsService.this.isJsessionIdCookieRequired(), AbstractSockJsService.this.isWebSocketEnabled());
                response.getBody().write(content.getBytes());
            } else if (HttpMethod.OPTIONS.equals((Object)request.getMethod())) {
                response.setStatusCode(HttpStatus.NO_CONTENT);
                AbstractSockJsService.this.addCorsHeaders(request, response, HttpMethod.OPTIONS, HttpMethod.GET);
                AbstractSockJsService.this.addCacheHeaders(response);
            } else {
                AbstractSockJsService.this.sendMethodNotAllowed(response, Arrays.asList(HttpMethod.OPTIONS, HttpMethod.GET));
            }
        }
    };
    private final SockJsRequestHandler iframeHandler = new SockJsRequestHandler(){
        private static final String IFRAME_CONTENT = "<!DOCTYPE html>\n<html>\n<head>\n  <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\" />\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n  <script>\n    document.domain = document.domain;\n    _sockjs_onload = function(){SockJS.bootstrap_iframe();};\n  </script>\n  <script src=\"%s\"></script>\n</head>\n<body>\n  <h2>Don't panic!</h2>\n  <p>This is a SockJS hidden iframe. It's used for cross domain magic.</p>\n</body>\n</html>";

        @Override
        public void handle(ServerHttpRequest request, ServerHttpResponse response) throws IOException {
            if (!HttpMethod.GET.equals((Object)request.getMethod())) {
                AbstractSockJsService.this.sendMethodNotAllowed(response, Arrays.asList(HttpMethod.GET));
                return;
            }
            String content = String.format(IFRAME_CONTENT, AbstractSockJsService.this.getSockJsClientLibraryUrl());
            byte[] contentBytes = content.getBytes(Charset.forName("UTF-8"));
            StringBuilder builder = new StringBuilder("\"0");
            DigestUtils.appendMd5DigestAsHex((byte[])contentBytes, (StringBuilder)builder);
            builder.append('\"');
            String etagValue = builder.toString();
            List ifNoneMatch = request.getHeaders().getIfNoneMatch();
            if (!CollectionUtils.isEmpty((Collection)ifNoneMatch) && ((String)ifNoneMatch.get(0)).equals(etagValue)) {
                response.setStatusCode(HttpStatus.NOT_MODIFIED);
                return;
            }
            response.getHeaders().setContentType(new MediaType("text", "html", Charset.forName("UTF-8")));
            response.getHeaders().setContentLength((long)contentBytes.length);
            AbstractSockJsService.this.addCacheHeaders(response);
            response.getHeaders().setETag(etagValue);
            response.getBody().write(contentBytes);
        }
    };

    public AbstractSockJsService(TaskScheduler scheduler) {
        Assert.notNull((Object)scheduler, (String)"scheduler is required");
        this.taskScheduler = scheduler;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setValidSockJsPrefixes(String ... prefixes) {
        this.validSockJsPrefixes.clear();
        for (String prefix : prefixes) {
            if (prefix.endsWith("/") && prefix.length() > 1) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
            this.validSockJsPrefixes.add(prefix);
        }
        Collections.sort(this.validSockJsPrefixes, Collections.reverseOrder(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return new Integer(o1.length()).compareTo(new Integer(o2.length()));
            }
        }));
    }

    public AbstractSockJsService setSockJsClientLibraryUrl(String clientLibraryUrl) {
        this.clientLibraryUrl = clientLibraryUrl;
        return this;
    }

    public String getSockJsClientLibraryUrl() {
        return this.clientLibraryUrl;
    }

    public AbstractSockJsService setStreamBytesLimit(int streamBytesLimit) {
        this.streamBytesLimit = streamBytesLimit;
        return this;
    }

    @Override
    public int getStreamBytesLimit() {
        return this.streamBytesLimit;
    }

    public AbstractSockJsService setJsessionIdCookieRequired(boolean jsessionIdCookieRequired) {
        this.jsessionIdCookieRequired = jsessionIdCookieRequired;
        return this;
    }

    public boolean isJsessionIdCookieRequired() {
        return this.jsessionIdCookieRequired;
    }

    public AbstractSockJsService setHeartbeatTime(long heartbeatTime) {
        this.heartbeatTime = heartbeatTime;
        return this;
    }

    @Override
    public long getHeartbeatTime() {
        return this.heartbeatTime;
    }

    @Override
    public TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public void setDisconnectDelay(long disconnectDelay) {
        this.disconnectDelay = disconnectDelay;
    }

    public long getDisconnectDelay() {
        return this.disconnectDelay;
    }

    public void setWebSocketsEnabled(boolean webSocketsEnabled) {
        this.webSocketsEnabled = webSocketsEnabled;
    }

    public boolean isWebSocketEnabled() {
        return this.webSocketsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void handleRequest(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler handler) throws IOException, TransportErrorException {
        String sockJsPath = this.getSockJsPath(request);
        if (sockJsPath == null) {
            this.logger.warn((Object)("Could not determine SockJS path for URL \"" + request.getURI().getPath() + ". Consider setting validSockJsPrefixes."));
            response.setStatusCode(HttpStatus.NOT_FOUND);
            return;
        }
        this.logger.debug((Object)(request.getMethod() + " with SockJS path [" + sockJsPath + "]"));
        try {
            request.getHeaders();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            if (sockJsPath.equals("") || sockJsPath.equals("/")) {
                response.getHeaders().setContentType(new MediaType("text", "plain", Charset.forName("UTF-8")));
                response.getBody().write("Welcome to SockJS!\n".getBytes("UTF-8"));
                return;
            }
            if (sockJsPath.equals("/info")) {
                this.infoHandler.handle(request, response);
                return;
            }
            if (sockJsPath.matches("/iframe[0-9-.a-z_]*.html")) {
                this.iframeHandler.handle(request, response);
                return;
            }
            if (sockJsPath.equals("/websocket")) {
                this.handleRawWebSocketRequest(request, response, handler);
                return;
            }
            String[] pathSegments = StringUtils.tokenizeToStringArray((String)sockJsPath.substring(1), (String)"/");
            if (pathSegments.length != 3) {
                this.logger.warn((Object)("Expected \"/{server}/{session}/{transport}\" but got \"" + sockJsPath + "\""));
                response.setStatusCode(HttpStatus.NOT_FOUND);
                return;
            }
            String serverId = pathSegments[0];
            String sessionId = pathSegments[1];
            String transport = pathSegments[2];
            if (!this.validateRequest(serverId, sessionId, transport)) {
                response.setStatusCode(HttpStatus.NOT_FOUND);
                return;
            }
            this.handleTransportRequest(request, response, sessionId, TransportType.fromValue(transport), handler);
        }
        finally {
            response.flush();
        }
    }

    private String getSockJsPath(ServerHttpRequest request) {
        String path = request.getURI().getPath();
        if (!this.validSockJsPrefixes.isEmpty()) {
            for (String prefix : this.validSockJsPrefixes) {
                int index = path.indexOf(prefix);
                if (index == -1) continue;
                this.knownSockJsPrefixes.add(path.substring(0, index + prefix.length()));
                return path.substring(index + prefix.length());
            }
            return null;
        }
        if (path.endsWith("/info")) {
            this.knownSockJsPrefixes.add(path.substring(0, path.length() - "/info".length()));
            return "/info";
        }
        String match = null;
        for (String sockJsPath : this.knownSockJsPrefixes) {
            if (!path.startsWith(sockJsPath) || match != null && match.length() >= sockJsPath.length()) continue;
            match = sockJsPath;
        }
        if (match != null) {
            String result = path.substring(match.length());
            Assert.isTrue((result.charAt(0) == '/' ? 1 : 0) != 0, (String)("Invalid SockJS path extracted from incoming path \"" + path + "\". The extracted SockJS path is \"" + result + "\". It was extracted from these known SockJS prefixes " + this.knownSockJsPrefixes + ". Consider setting 'validSockJsPrefixes' on DefaultSockJsService."));
            return result;
        }
        String pathNoSlash = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        String lastSegment = pathNoSlash.substring(pathNoSlash.lastIndexOf(47) + 1);
        if (TransportType.fromValue(lastSegment) == null && !lastSegment.startsWith("iframe")) {
            this.knownSockJsPrefixes.add(path);
            return "";
        }
        return null;
    }

    protected abstract void handleRawWebSocketRequest(ServerHttpRequest var1, ServerHttpResponse var2, WebSocketHandler var3) throws IOException;

    protected abstract void handleTransportRequest(ServerHttpRequest var1, ServerHttpResponse var2, String var3, TransportType var4, WebSocketHandler var5) throws IOException, TransportErrorException;

    protected boolean validateRequest(String serverId, String sessionId, String transport) {
        if (!(StringUtils.hasText((String)serverId) && StringUtils.hasText((String)sessionId) && StringUtils.hasText((String)transport))) {
            this.logger.warn((Object)"Empty server, session, or transport value");
            return false;
        }
        if (serverId.contains(".") || sessionId.contains(".")) {
            this.logger.warn((Object)"Server or session contain a \".\"");
            return false;
        }
        if (!this.isWebSocketEnabled() && transport.equals(TransportType.WEBSOCKET.value())) {
            this.logger.warn((Object)"Websocket transport is disabled");
            return false;
        }
        return true;
    }

    protected void addCorsHeaders(ServerHttpRequest request, ServerHttpResponse response, HttpMethod ... httpMethods) {
        String origin = request.getHeaders().getFirst("origin");
        origin = origin == null || origin.equals("null") ? "*" : origin;
        response.getHeaders().add("Access-Control-Allow-Origin", origin);
        response.getHeaders().add("Access-Control-Allow-Credentials", "true");
        List accessControllerHeaders = request.getHeaders().get((Object)"Access-Control-Request-Headers");
        if (accessControllerHeaders != null) {
            for (String header : accessControllerHeaders) {
                response.getHeaders().add("Access-Control-Allow-Headers", header);
            }
        }
        if (!ObjectUtils.isEmpty((Object[])httpMethods)) {
            response.getHeaders().add("Access-Control-Allow-Methods", StringUtils.arrayToDelimitedString((Object[])httpMethods, (String)", "));
            response.getHeaders().add("Access-Control-Max-Age", String.valueOf(31536000));
        }
    }

    protected void addCacheHeaders(ServerHttpResponse response) {
        response.getHeaders().setCacheControl("public, max-age=31536000");
        response.getHeaders().setExpires(new Date().getTime() + 1471228928L);
    }

    protected void addNoCacheHeaders(ServerHttpResponse response) {
        response.getHeaders().setCacheControl("no-store, no-cache, must-revalidate, max-age=0");
    }

    protected void sendMethodNotAllowed(ServerHttpResponse response, List<HttpMethod> httpMethods) throws IOException {
        this.logger.debug((Object)"Sending Method Not Allowed (405)");
        response.setStatusCode(HttpStatus.METHOD_NOT_ALLOWED);
        response.getHeaders().setAllow(new HashSet<HttpMethod>(httpMethods));
    }

    private static interface SockJsRequestHandler {
        public void handle(ServerHttpRequest var1, ServerHttpResponse var2) throws IOException;
    }
}

