/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.net.URI;
import java.security.Principal;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.adapter.ConfigurableWebSocketSession;
import org.springframework.web.socket.sockjs.SockJsConfiguration;
import org.springframework.web.socket.sockjs.SockJsFrame;
import org.springframework.web.socket.sockjs.TransportErrorException;

public abstract class AbstractSockJsSession
implements ConfigurableWebSocketSession {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final String id;
    private URI uri;
    private String remoteHostName;
    private String remoteAddress;
    private Principal principal;
    private final SockJsConfiguration sockJsConfig;
    private WebSocketHandler handler;
    private State state = State.NEW;
    private long timeCreated;
    private long timeLastActive = this.timeCreated = System.currentTimeMillis();
    private ScheduledFuture<?> heartbeatTask;

    public AbstractSockJsSession(String sessionId, SockJsConfiguration config, WebSocketHandler webSocketHandler) {
        Assert.notNull((Object)sessionId, (String)"sessionId is required");
        Assert.notNull((Object)webSocketHandler, (String)"webSocketHandler is required");
        this.id = sessionId;
        this.handler = webSocketHandler;
        this.sockJsConfig = config;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public void setUri(URI uri) {
        this.uri = uri;
    }

    @Override
    public boolean isSecure() {
        return "wss".equals(this.uri.getSchemeSpecificPart());
    }

    @Override
    public String getRemoteHostName() {
        return this.remoteHostName;
    }

    @Override
    public void setRemoteHostName(String remoteHostName) {
        this.remoteHostName = remoteHostName;
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @Override
    public Principal getPrincipal() {
        return this.principal;
    }

    @Override
    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    public SockJsConfiguration getSockJsConfig() {
        return this.sockJsConfig;
    }

    public boolean isNew() {
        return State.NEW.equals((Object)this.state);
    }

    @Override
    public boolean isOpen() {
        return State.OPEN.equals((Object)this.state);
    }

    public boolean isClosed() {
        return State.CLOSED.equals((Object)this.state);
    }

    public abstract boolean isActive();

    public long getTimeSinceLastActive() {
        if (this.isNew()) {
            return System.currentTimeMillis() - this.timeCreated;
        }
        return this.isActive() ? 0L : System.currentTimeMillis() - this.timeLastActive;
    }

    protected void updateLastActiveTime() {
        this.timeLastActive = System.currentTimeMillis();
    }

    public void delegateConnectionEstablished() throws Exception {
        this.state = State.OPEN;
        this.handler.afterConnectionEstablished(this);
    }

    public void delegateMessages(String[] messages) throws Exception {
        for (String message : messages) {
            this.handler.handleMessage(this, new TextMessage(message));
        }
    }

    public final void delegateConnectionClosed(CloseStatus status) throws Exception {
        if (!this.isClosed()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(this + " was closed, " + status));
            }
            try {
                this.updateLastActiveTime();
                this.cancelHeartbeat();
            }
            finally {
                this.state = State.CLOSED;
                this.handler.afterConnectionClosed(this, status);
            }
        }
    }

    public void delegateError(Throwable ex) throws Exception {
        this.handler.handleTransportError(this, ex);
    }

    public final synchronized void sendMessage(WebSocketMessage message) throws IOException {
        Assert.isTrue((!this.isClosed() ? 1 : 0) != 0, (String)"Cannot send a message when session is closed");
        Assert.isInstanceOf(TextMessage.class, (Object)message, (String)("Expected text message: " + message));
        this.sendMessageInternal((String)((TextMessage)message).getPayload());
    }

    protected abstract void sendMessageInternal(String var1) throws IOException;

    @Override
    public final void close() throws IOException {
        this.close(new CloseStatus(3000, "Go away!"));
    }

    @Override
    public final void close(CloseStatus status) throws IOException {
        if (this.isOpen()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Closing " + this + ", " + status));
            }
            try {
                if (this.isActive()) {
                    try {
                        this.writeFrameInternal(SockJsFrame.closeFrame(status.getCode(), status.getReason()));
                    }
                    catch (Throwable ex) {
                        this.logger.warn((Object)("Failed to send SockJS close frame: " + ex.getMessage()));
                    }
                }
                this.updateLastActiveTime();
                this.cancelHeartbeat();
                this.disconnect(status);
            }
            finally {
                this.state = State.CLOSED;
                try {
                    this.handler.afterConnectionClosed(this, status);
                }
                catch (Throwable t) {
                    this.logger.error((Object)("Unhandled error for " + this), t);
                }
            }
        }
    }

    protected abstract void disconnect(CloseStatus var1) throws IOException;

    protected void tryCloseWithSockJsTransportError(Throwable ex, CloseStatus closeStatus) {
        this.logger.error((Object)("Closing due to transport error for " + this), ex);
        try {
            this.delegateError(ex);
        }
        catch (Throwable delegateEx) {
            this.logger.error((Object)("Unhandled error for " + this), delegateEx);
            try {
                this.close(closeStatus);
            }
            catch (Throwable closeEx) {
                this.logger.error((Object)("Unhandled error for " + this), closeEx);
            }
        }
    }

    protected void writeFrame(SockJsFrame frame) throws IOException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Preparing to write " + frame));
        }
        try {
            this.writeFrameInternal(frame);
        }
        catch (IOException ex) {
            if (ex instanceof EOFException || ex instanceof SocketException) {
                this.logger.warn((Object)"Client went away. Terminating connection");
            } else {
                this.logger.warn((Object)("Terminating connection due to failure to send message: " + ex.getMessage()));
            }
            this.disconnect(CloseStatus.SERVER_ERROR);
            this.close(CloseStatus.SERVER_ERROR);
            throw ex;
        }
        catch (Throwable ex) {
            this.logger.warn((Object)("Terminating connection due to failure to send message: " + ex.getMessage()));
            this.disconnect(CloseStatus.SERVER_ERROR);
            this.close(CloseStatus.SERVER_ERROR);
            throw new TransportErrorException("Failed to write " + frame, ex, this.getId());
        }
    }

    protected abstract void writeFrameInternal(SockJsFrame var1) throws Exception;

    public synchronized void sendHeartbeat() throws Exception {
        if (this.isActive()) {
            this.writeFrame(SockJsFrame.heartbeatFrame());
            this.scheduleHeartbeat();
        }
    }

    protected void scheduleHeartbeat() {
        Assert.notNull((Object)this.sockJsConfig.getTaskScheduler(), (String)"heartbeatScheduler not configured");
        this.cancelHeartbeat();
        if (!this.isActive()) {
            return;
        }
        Date time = new Date(System.currentTimeMillis() + this.sockJsConfig.getHeartbeatTime());
        this.heartbeatTask = this.sockJsConfig.getTaskScheduler().schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractSockJsSession.this.sendHeartbeat();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, time);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Scheduled heartbeat after " + this.sockJsConfig.getHeartbeatTime() / 1000L + " seconds"));
        }
    }

    protected void cancelHeartbeat() {
        if (this.heartbeatTask != null && !this.heartbeatTask.isDone()) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Cancelling heartbeat");
            }
            this.heartbeatTask.cancel(false);
        }
        this.heartbeatTask = null;
    }

    public String toString() {
        return "SockJS session id=" + this.id;
    }

    private static enum State {
        NEW,
        OPEN,
        CLOSED;

    }
}

