/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import java.nio.charset.Charset;
import org.springframework.util.Assert;

public class SockJsFrame {
    private static final SockJsFrame OPEN_FRAME = new SockJsFrame("o");
    private static final SockJsFrame HEARTBEAT_FRAME = new SockJsFrame("h");
    private static final SockJsFrame CLOSE_GO_AWAY_FRAME = SockJsFrame.closeFrame(3000, "Go away!");
    private static final SockJsFrame CLOSE_ANOTHER_CONNECTION_OPEN = SockJsFrame.closeFrame(2010, "Another connection still open");
    private final String content;

    private SockJsFrame(String content) {
        Assert.notNull((Object)"content is required");
        this.content = content;
    }

    public static SockJsFrame openFrame() {
        return OPEN_FRAME;
    }

    public static SockJsFrame heartbeatFrame() {
        return HEARTBEAT_FRAME;
    }

    public static SockJsFrame messageFrame(String ... messages) {
        return new MessageFrame(messages);
    }

    public static SockJsFrame closeFrameGoAway() {
        return CLOSE_GO_AWAY_FRAME;
    }

    public static SockJsFrame closeFrameAnotherConnectionOpen() {
        return CLOSE_ANOTHER_CONNECTION_OPEN;
    }

    public static SockJsFrame closeFrame(int code, String reason) {
        return new SockJsFrame("c[" + code + ",\"" + reason + "\"]");
    }

    public String getContent() {
        return this.content;
    }

    public byte[] getContentBytes() {
        return this.content.getBytes(Charset.forName("UTF-8"));
    }

    public static String escapeCharacters(char[] characters) {
        StringBuilder result = new StringBuilder();
        for (char c : characters) {
            if (SockJsFrame.isSockJsEscapeCharacter(c)) {
                result.append('\\').append('u');
                String hex = Integer.toHexString(c).toLowerCase();
                for (int i = 0; i < 4 - hex.length(); ++i) {
                    result.append('0');
                }
                result.append(hex);
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private static boolean isSockJsEscapeCharacter(char ch) {
        return ch >= '\u0000' && ch <= '\u001f' || ch >= '\u200c' && ch <= '\u200f' || ch >= '\u2028' && ch <= '\u202f' || ch >= '\u2060' && ch <= '\u206f' || ch >= '\ufff0' && ch <= '\uffff' || ch >= '\ud800' && ch <= '\udfff';
    }

    public String toString() {
        String result = this.content;
        if (result.length() > 80) {
            result = result.substring(0, 80) + "...(truncated)";
        }
        return "SockJsFrame content='" + result.replace("\n", "\\n").replace("\r", "\\r") + "'";
    }

    public int hashCode() {
        return this.content.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SockJsFrame)) {
            return false;
        }
        return this.content.equals(((SockJsFrame)other).content);
    }

    public static class DefaultFrameFormat
    implements FrameFormat {
        private final String format;

        public DefaultFrameFormat(String format) {
            Assert.notNull((Object)format, (String)"format is required");
            this.format = format;
        }

        @Override
        public SockJsFrame format(SockJsFrame frame) {
            String content = String.format(this.format, this.preProcessContent(frame.getContent()));
            return new SockJsFrame(content);
        }

        protected String preProcessContent(String content) {
            return content;
        }
    }

    public static interface FrameFormat {
        public SockJsFrame format(SockJsFrame var1);
    }

    private static class MessageFrame
    extends SockJsFrame {
        public MessageFrame(String ... messages) {
            super(MessageFrame.prepareContent(messages));
        }

        public static String prepareContent(String ... messages) {
            Assert.notNull((Object)messages, (String)"messages required");
            StringBuilder sb = new StringBuilder();
            sb.append("a[");
            for (int i = 0; i < messages.length; ++i) {
                sb.append('\"');
                char[] quotedChars = JsonStringEncoder.getInstance().quoteAsString(messages[i]);
                sb.append(MessageFrame.escapeCharacters(quotedChars));
                sb.append('\"');
                if (i >= messages.length - 1) continue;
                sb.append(',');
            }
            sb.append(']');
            return sb.toString();
        }
    }
}

