/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpMethod;

public enum TransportType {
    WEBSOCKET("websocket", HttpMethod.GET, new String[0]),
    XHR("xhr", HttpMethod.POST, "cors", "jsessionid", "no_cache"),
    XHR_SEND("xhr_send", HttpMethod.POST, "cors", "jsessionid", "no_cache"),
    JSONP("jsonp", HttpMethod.GET, "jsessionid", "no_cache"),
    JSONP_SEND("jsonp_send", HttpMethod.POST, "jsessionid", "no_cache"),
    XHR_STREAMING("xhr_streaming", HttpMethod.POST, "cors", "jsessionid", "no_cache"),
    EVENT_SOURCE("eventsource", HttpMethod.GET, "jsessionid", "no_cache"),
    HTML_FILE("htmlfile", HttpMethod.GET, "jsessionid", "no_cache");

    private final String value;
    private final HttpMethod httpMethod;
    private final List<String> headerHints;
    private static final Map<String, TransportType> transportTypes;

    private TransportType(String value, HttpMethod httpMethod, String ... headerHints) {
        this.value = value;
        this.httpMethod = httpMethod;
        this.headerHints = Arrays.asList(headerHints);
    }

    public String value() {
        return this.value;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public boolean sendsNoCacheInstruction() {
        return this.headerHints.contains("no_cache");
    }

    public boolean supportsCors() {
        return this.headerHints.contains("cors");
    }

    public boolean setsJsessionId() {
        return this.headerHints.contains("jsessionid");
    }

    public static TransportType fromValue(String value) {
        return transportTypes.get(value);
    }

    public String toString() {
        return this.value;
    }

    static {
        transportTypes = new HashMap<String, TransportType>();
        for (TransportType type : TransportType.values()) {
            transportTypes.put(type.value, type);
        }
    }
}

