/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.support;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.springframework.http.Cookie;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.DefaultHandshakeHandler;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.support.ServerWebSocketSessionInitializer;
import org.springframework.web.socket.sockjs.AbstractSockJsService;
import org.springframework.web.socket.sockjs.AbstractSockJsSession;
import org.springframework.web.socket.sockjs.ConfigurableTransportHandler;
import org.springframework.web.socket.sockjs.SockJsSessionFactory;
import org.springframework.web.socket.sockjs.TransportErrorException;
import org.springframework.web.socket.sockjs.TransportHandler;
import org.springframework.web.socket.sockjs.TransportType;
import org.springframework.web.socket.sockjs.transport.EventSourceTransportHandler;
import org.springframework.web.socket.sockjs.transport.HtmlFileTransportHandler;
import org.springframework.web.socket.sockjs.transport.JsonpPollingTransportHandler;
import org.springframework.web.socket.sockjs.transport.JsonpTransportHandler;
import org.springframework.web.socket.sockjs.transport.WebSocketTransportHandler;
import org.springframework.web.socket.sockjs.transport.XhrPollingTransportHandler;
import org.springframework.web.socket.sockjs.transport.XhrStreamingTransportHandler;
import org.springframework.web.socket.sockjs.transport.XhrTransportHandler;

public class DefaultSockJsService
extends AbstractSockJsService {
    private final Map<TransportType, TransportHandler> transportHandlers = new HashMap<TransportType, TransportHandler>();
    private final Map<String, AbstractSockJsSession> sessions = new ConcurrentHashMap<String, AbstractSockJsSession>();
    private final ServerWebSocketSessionInitializer sessionInitializer = new ServerWebSocketSessionInitializer();
    private ScheduledFuture sessionCleanupTask;

    public DefaultSockJsService(TaskScheduler taskScheduler) {
        super(taskScheduler);
        this.addTransportHandlers(this.getDefaultTransportHandlers());
    }

    public DefaultSockJsService(TaskScheduler taskScheduler, Set<TransportHandler> transportHandlers, TransportHandler ... transportHandlerOverrides) {
        super(taskScheduler);
        if (!CollectionUtils.isEmpty(transportHandlers)) {
            this.addTransportHandlers(transportHandlers);
        }
        if (!ObjectUtils.isEmpty((Object[])transportHandlerOverrides)) {
            this.addTransportHandlers(Arrays.asList(transportHandlerOverrides));
        }
        if (this.transportHandlers.isEmpty()) {
            this.logger.warn((Object)"No transport handlers");
        }
    }

    protected final Set<TransportHandler> getDefaultTransportHandlers() {
        HashSet<TransportHandler> result;
        block2: {
            result = new HashSet<TransportHandler>();
            result.add(new XhrPollingTransportHandler());
            result.add(new XhrTransportHandler());
            result.add(new JsonpPollingTransportHandler());
            result.add(new JsonpTransportHandler());
            result.add(new XhrStreamingTransportHandler());
            result.add(new EventSourceTransportHandler());
            result.add(new HtmlFileTransportHandler());
            try {
                result.add(new WebSocketTransportHandler(new DefaultHandshakeHandler()));
            }
            catch (Exception ex) {
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn((Object)("Failed to add default WebSocketTransportHandler: " + ex.getMessage()));
            }
        }
        return result;
    }

    protected void addTransportHandlers(Collection<TransportHandler> handlers) {
        for (TransportHandler handler : handlers) {
            if (handler instanceof ConfigurableTransportHandler) {
                ((ConfigurableTransportHandler)handler).setSockJsConfiguration(this);
            }
            this.transportHandlers.put(handler.getTransportType(), handler);
        }
    }

    public Map<TransportType, TransportHandler> getTransportHandlers() {
        return Collections.unmodifiableMap(this.transportHandlers);
    }

    @Override
    protected void handleRawWebSocketRequest(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler webSocketHandler) throws IOException {
        if (this.isWebSocketEnabled()) {
            TransportHandler transportHandler = this.transportHandlers.get((Object)TransportType.WEBSOCKET);
            if (transportHandler != null && transportHandler instanceof HandshakeHandler) {
                ((HandshakeHandler)((Object)transportHandler)).doHandshake(request, response, webSocketHandler);
                return;
            }
            this.logger.warn((Object)"No handler for raw WebSocket messages");
        }
        response.setStatusCode(HttpStatus.NOT_FOUND);
    }

    @Override
    protected void handleTransportRequest(ServerHttpRequest request, ServerHttpResponse response, String sessionId, TransportType transportType, WebSocketHandler webSocketHandler) throws IOException, TransportErrorException {
        TransportHandler transportHandler = this.transportHandlers.get((Object)transportType);
        if (transportHandler == null) {
            this.logger.debug((Object)"Transport handler not found");
            response.setStatusCode(HttpStatus.NOT_FOUND);
            return;
        }
        HttpMethod supportedMethod = transportType.getHttpMethod();
        if (!supportedMethod.equals((Object)request.getMethod())) {
            if (HttpMethod.OPTIONS.equals((Object)request.getMethod()) && transportType.supportsCors()) {
                response.setStatusCode(HttpStatus.NO_CONTENT);
                this.addCorsHeaders(request, response, HttpMethod.OPTIONS, supportedMethod);
                this.addCacheHeaders(response);
            } else {
                List<HttpMethod> supportedMethods = Arrays.asList(supportedMethod);
                if (transportType.supportsCors()) {
                    supportedMethods.add(HttpMethod.OPTIONS);
                }
                this.sendMethodNotAllowed(response, supportedMethods);
            }
            return;
        }
        AbstractSockJsSession session = this.getSockJsSession(sessionId, webSocketHandler, transportHandler, request, response);
        if (session != null) {
            if (transportType.sendsNoCacheInstruction()) {
                this.addNoCacheHeaders(response);
            }
            if (transportType.setsJsessionId() && this.isJsessionIdCookieRequired()) {
                Cookie cookie = request.getCookies().getCookie("JSESSIONID");
                String jsid = cookie != null ? cookie.getValue() : "dummy";
                response.getHeaders().set("Set-Cookie", "JSESSIONID=" + jsid + ";path=/");
            }
            if (transportType.supportsCors()) {
                this.addCorsHeaders(request, response, new HttpMethod[0]);
            }
        }
        transportHandler.handleRequest(request, response, webSocketHandler, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractSockJsSession getSockJsSession(String sessionId, WebSocketHandler handler, TransportHandler transportHandler, ServerHttpRequest request, ServerHttpResponse response) {
        AbstractSockJsSession session = this.sessions.get(sessionId);
        if (session != null) {
            return session;
        }
        if (transportHandler instanceof SockJsSessionFactory) {
            SockJsSessionFactory sessionFactory = (SockJsSessionFactory)((Object)transportHandler);
            Map<String, AbstractSockJsSession> map = this.sessions;
            synchronized (map) {
                session = this.sessions.get(sessionId);
                if (session != null) {
                    return session;
                }
                if (this.sessionCleanupTask == null) {
                    this.scheduleSessionTask();
                }
                this.logger.debug((Object)("Creating new session with session id \"" + sessionId + "\""));
                session = sessionFactory.createSession(sessionId, handler);
                this.sessionInitializer.initialize(request, response, session);
                this.sessions.put(sessionId, session);
                return session;
            }
        }
        return null;
    }

    private void scheduleSessionTask() {
        this.sessionCleanupTask = this.getTaskScheduler().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    int count = DefaultSockJsService.this.sessions.size();
                    if (DefaultSockJsService.this.logger.isTraceEnabled() && count != 0) {
                        DefaultSockJsService.this.logger.trace((Object)("Checking " + count + " session(s) for timeouts [" + DefaultSockJsService.this.getName() + "]"));
                    }
                    for (AbstractSockJsSession session : DefaultSockJsService.this.sessions.values()) {
                        if (session.getTimeSinceLastActive() <= DefaultSockJsService.this.getDisconnectDelay()) continue;
                        if (DefaultSockJsService.this.logger.isTraceEnabled()) {
                            DefaultSockJsService.this.logger.trace((Object)("Removing " + session + " for [" + DefaultSockJsService.this.getName() + "]"));
                        }
                        session.close();
                        DefaultSockJsService.this.sessions.remove(session.getId());
                    }
                    if (DefaultSockJsService.this.logger.isTraceEnabled() && count != 0) {
                        DefaultSockJsService.this.logger.trace((Object)(DefaultSockJsService.this.sessions.size() + " remaining session(s) [" + DefaultSockJsService.this.getName() + "]"));
                    }
                }
                catch (Throwable t) {
                    DefaultSockJsService.this.logger.error((Object)("Failed to complete session timeout checks for [" + DefaultSockJsService.this.getName() + "]"), t);
                }
            }
        }, this.getDisconnectDelay());
    }
}

