/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.support;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.server.AsyncServletServerHttpRequest;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.sockjs.SockJsService;
import org.springframework.web.socket.support.ExceptionWebSocketHandlerDecorator;
import org.springframework.web.socket.support.LoggingWebSocketHandlerDecorator;

public class SockJsHttpRequestHandler
implements HttpRequestHandler {
    private final SockJsService sockJsService;
    private final WebSocketHandler webSocketHandler;

    public SockJsHttpRequestHandler(SockJsService sockJsService, WebSocketHandler webSocketHandler) {
        Assert.notNull((Object)sockJsService, (String)"sockJsService is required");
        Assert.notNull((Object)webSocketHandler, (String)"webSocketHandler is required");
        this.sockJsService = sockJsService;
        this.webSocketHandler = this.decorateWebSocketHandler(webSocketHandler);
    }

    protected WebSocketHandler decorateWebSocketHandler(WebSocketHandler handler) {
        handler = new ExceptionWebSocketHandlerDecorator(handler);
        return new LoggingWebSocketHandlerDecorator(handler);
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncServletServerHttpRequest httpRequest = new AsyncServletServerHttpRequest(request, response);
        ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
        this.sockJsService.handleRequest((ServerHttpRequest)httpRequest, (ServerHttpResponse)httpResponse, this.webSocketHandler);
    }
}

