/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport;

import java.io.IOException;
import java.nio.charset.Charset;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.sockjs.SockJsFrame;
import org.springframework.web.socket.sockjs.TransportErrorException;
import org.springframework.web.socket.sockjs.TransportType;
import org.springframework.web.socket.sockjs.transport.AbstractHttpSendingTransportHandler;
import org.springframework.web.socket.sockjs.transport.AbstractHttpSockJsSession;
import org.springframework.web.socket.sockjs.transport.StreamingSockJsSession;
import org.springframework.web.util.JavaScriptUtils;

public class HtmlFileTransportHandler
extends AbstractHttpSendingTransportHandler {
    private static final String PARTIAL_HTML_CONTENT;

    @Override
    public TransportType getTransportType() {
        return TransportType.HTML_FILE;
    }

    @Override
    protected MediaType getContentType() {
        return new MediaType("text", "html", Charset.forName("UTF-8"));
    }

    @Override
    public StreamingSockJsSession createSession(String sessionId, WebSocketHandler handler) {
        Assert.notNull((Object)this.getSockJsConfig(), (String)"This transport requires SockJsConfiguration");
        return new StreamingSockJsSession(sessionId, this.getSockJsConfig(), handler){

            @Override
            protected void writePrelude() throws IOException {
                String callback = (String)this.getRequest().getQueryParams().getFirst((Object)"c");
                String html = String.format(PARTIAL_HTML_CONTENT, callback);
                this.getResponse().getBody().write(html.getBytes("UTF-8"));
                this.getResponse().flush();
            }
        };
    }

    @Override
    public void handleRequestInternal(ServerHttpRequest request, ServerHttpResponse response, AbstractHttpSockJsSession session) throws TransportErrorException {
        try {
            String callback = (String)request.getQueryParams().getFirst((Object)"c");
            if (!StringUtils.hasText((String)callback)) {
                response.setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
                response.getBody().write("\"callback\" parameter required".getBytes("UTF-8"));
                return;
            }
        }
        catch (Throwable t) {
            throw new TransportErrorException("Failed to send error to client", t, session.getId());
        }
        super.handleRequestInternal(request, response, session);
    }

    @Override
    protected SockJsFrame.FrameFormat getFrameFormat(ServerHttpRequest request) {
        return new SockJsFrame.DefaultFrameFormat("<script>\np(\"%s\");\n</script>\r\n"){

            @Override
            protected String preProcessContent(String content) {
                return JavaScriptUtils.javaScriptEscape((String)content);
            }
        };
    }

    static {
        StringBuilder sb = new StringBuilder("<!doctype html>\n<html><head>\n  <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\" />\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n</head><body><h2>Don't panic!</h2>\n  <script>\n    document.domain = document.domain;\n    var c = parent.%s;\n    c.start();\n    function p(d) {c.message(d);};\n    window.onload = function() {c.stop();};\n  </script>");
        int spaces = 1024 - sb.length();
        for (int i = 0; i < spaces; ++i) {
            sb.append(' ');
        }
        PARTIAL_HTML_CONTENT = sb.toString();
    }
}

