/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport;

import java.io.IOException;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.sockjs.AbstractSockJsSession;
import org.springframework.web.socket.sockjs.TransportErrorException;
import org.springframework.web.socket.sockjs.TransportType;
import org.springframework.web.socket.sockjs.transport.AbstractHttpReceivingTransportHandler;

public class JsonpTransportHandler
extends AbstractHttpReceivingTransportHandler {
    private final FormHttpMessageConverter formConverter = new FormHttpMessageConverter();

    @Override
    public TransportType getTransportType() {
        return TransportType.JSONP_SEND;
    }

    @Override
    public void handleRequestInternal(ServerHttpRequest request, ServerHttpResponse response, AbstractSockJsSession sockJsSession) throws TransportErrorException {
        super.handleRequestInternal(request, response, sockJsSession);
        try {
            response.getBody().write("ok".getBytes("UTF-8"));
        }
        catch (Throwable t) {
            throw new TransportErrorException("Failed to write response body", t, sockJsSession.getId());
        }
    }

    @Override
    protected String[] readMessages(ServerHttpRequest request) throws IOException {
        if (MediaType.APPLICATION_FORM_URLENCODED.equals((Object)request.getHeaders().getContentType())) {
            MultiValueMap map = this.formConverter.read(null, (HttpInputMessage)request);
            String d = (String)map.getFirst((Object)"d");
            return StringUtils.hasText((String)d) ? (String[])this.getObjectMapper().readValue(d, String[].class) : null;
        }
        return (String[])this.getObjectMapper().readValue(request.getBody(), String[].class);
    }

    @Override
    protected HttpStatus getResponseStatus() {
        return HttpStatus.OK;
    }
}

