/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport;

import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.util.Assert;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.adapter.TextWebSocketHandlerAdapter;
import org.springframework.web.socket.sockjs.SockJsConfiguration;
import org.springframework.web.socket.sockjs.transport.WebSocketServerSockJsSession;

public class SockJsWebSocketHandler
extends TextWebSocketHandlerAdapter {
    private final SockJsConfiguration sockJsConfig;
    private WebSocketServerSockJsSession session;
    private final AtomicInteger sessionCount = new AtomicInteger(0);

    public SockJsWebSocketHandler(SockJsConfiguration config, WebSocketHandler webSocketHandler, WebSocketServerSockJsSession session) {
        Assert.notNull((Object)config, (String)"sockJsConfig is required");
        Assert.notNull((Object)webSocketHandler, (String)"webSocketHandler is required");
        Assert.notNull((Object)session, (String)"session is required");
        this.sockJsConfig = config;
        this.session = session;
    }

    protected SockJsConfiguration getSockJsConfig() {
        return this.sockJsConfig;
    }

    @Override
    public void afterConnectionEstablished(WebSocketSession wsSession) throws Exception {
        Assert.isTrue((boolean)this.sessionCount.compareAndSet(0, 1), (String)"Unexpected connection");
        this.session.initWebSocketSession(wsSession);
    }

    @Override
    public void handleTextMessage(WebSocketSession wsSession, TextMessage message) throws Exception {
        this.session.handleMessage(message, wsSession);
    }

    @Override
    public void afterConnectionClosed(WebSocketSession wsSession, CloseStatus status) throws Exception {
        this.session.delegateConnectionClosed(status);
    }

    @Override
    public void handleTransportError(WebSocketSession webSocketSession, Throwable exception) throws Exception {
        this.session.delegateError(exception);
    }
}

